/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.KleinbergSmallWorldGenerator;
import gr.forth.ics.graph.algo.WattsStrogatzGenerator;
import gr.forth.ics.graph.event.EmptyGraphListener;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.path.Cycles;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.Paths;
import gr.forth.ics.graph.util.Graphs;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.TransformingIterable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generators {
    private Generators() {
    }

    public static Path createPath(Graph g, int nodes) {
        Node[] n = g.newNodes(nodes);
        LinkedList<Edge> edges = new LinkedList<Edge>();
        for (int i = 1; i < n.length; ++i) {
            edges.add(g.newEdge(n[i - 1], n[i]));
        }
        return Generators.createPathFromEdges(edges);
    }

    public static Path createCycle(Graph g, int nodes) {
        Node[] n = g.newNodes(nodes);
        LinkedList<Edge> edges = new LinkedList<Edge>();
        for (int i = 1; i < n.length; ++i) {
            edges.add(g.newEdge(n[i - 1], n[i]));
        }
        edges.addLast(g.newEdge(n[n.length - 1], n[0]));
        return Generators.createPathFromEdges(edges);
    }

    private static Path createPathFromEdges(List<Edge> edges) {
        return Paths.newPath((Iterable<Path>)new TransformingIterable<Edge, Path>(edges){

            @Override
            protected Path transform(Edge source) {
                return source.asPath();
            }
        });
    }

    public static void createGrid(Graph g, int ... nodesPerDimension) {
        Generators.createGrid(g, false, nodesPerDimension);
    }

    public static void createFoldedGrid(Graph g, int ... nodesPerDimension) {
        Generators.createGrid(g, true, nodesPerDimension);
    }

    private static void createGrid(Graph g, boolean folded, int ... nodesPerDimension) {
        Args.notNull((Object)g);
        if (nodesPerDimension.length == 0) {
            return;
        }
        int totalNodes = 1;
        for (int dimension : nodesPerDimension) {
            totalNodes *= dimension;
        }
        Mapper mapper = new Mapper(nodesPerDimension);
        Node[] nodes = g.newNodes(totalNodes);
        int[] point = new int[nodesPerDimension.length];
        int[] nextPoint = new int[nodesPerDimension.length];
        for (int i = 0; i < totalNodes; ++i) {
            Node n1 = nodes[i];
            mapper.indexToPoint(i, point);
            for (int k = 0; k < nodesPerDimension.length; ++k) {
                nextPoint[k] = point[k];
            }
            for (int j = 0; j < nodesPerDimension.length; ++j) {
                int n = j;
                nextPoint[n] = nextPoint[n] + 1;
                if (nextPoint[j] == nodesPerDimension[j]) {
                    nextPoint[j] = 0;
                    if (!folded) {
                        nextPoint[j] = point[j];
                        continue;
                    }
                }
                Node n2 = nodes[mapper.pointToIndex(nextPoint)];
                g.newEdge(n1, n2);
                nextPoint[j] = point[j];
            }
        }
    }

    public static void createSmallWorld_Kleinberg(Graph g, int gridSize, double clusteringExponent) {
        Generators.createSmallWorld_Kleinberg(g, new Random(), gridSize, 2.0);
    }

    public static void createSmallWorld_Kleinberg(Graph g, Random random, int gridSize, double clusteringExponent) {
        Args.notNull((Object)g);
        Args.notNull((Object)random);
        new KleinbergSmallWorldGenerator(random, gridSize, clusteringExponent).generate(g);
    }

    public static void createSmallWorld_Watts(Graph g, int nodes, int k, double p) {
        Generators.createSmallWorld_Watts(g, new Random(), nodes, k, p);
    }

    public static void createSmallWorld_Watts(Graph g, Random random, int nodes, int k, double p) {
        new WattsStrogatzGenerator(random, nodes, p, k);
    }

    public static void createRingLattice(Graph g, int nodes, int neighbors) {
        Args.gte((double)nodes, 2.0);
        Args.inRangeII(neighbors, 2, (nodes - 2) / 2);
        Node[] n = g.newNodes(nodes);
        for (int i = 0; i < nodes; ++i) {
            for (int j = 0; j < neighbors; ++j) {
                g.newEdge(n[i], n[(i + (neighbors - j)) % nodes]);
            }
        }
    }

    public static void createRandom(Graph g, int nodes, double p) {
        Generators.createRandom(g, new Random(), nodes, p);
    }

    public static void createRandom(Graph g, Random random, int nodes, double p) {
        Node[] n;
        Args.gt(nodes, 0);
        Args.notNull((Object)random);
        Args.inRangeII(Double.valueOf(p), 0.0, 1.0);
        for (Node n1 : n = g.newNodes(nodes)) {
            for (Node n2 : n) {
                if (!(random.nextDouble() < p)) continue;
                g.newEdge(n1, n2);
            }
        }
    }

    public static Node createRandomTree(Graph g, int nodes, Direction directionFromRoot) {
        return Generators.createRandomTree(g, new Random(), nodes, directionFromRoot);
    }

    public static Node createRandomTree(Graph g, Random random, int nodes, Direction directionFromRoot) {
        Args.notNull((Object)g);
        Args.notNull((Object)random);
        Args.notNull((Object)directionFromRoot);
        ArrayList<Node> parents = new ArrayList<Node>();
        while (nodes-- > 0) {
            Node newNode = g.newNode();
            if (!parents.isEmpty()) {
                Node parent = (Node)parents.get(random.nextInt(parents.size()));
                switch (directionFromRoot) {
                    case OUT: {
                        g.newEdge(parent, newNode);
                        break;
                    }
                    case IN: {
                        g.newEdge(newNode, parent);
                        break;
                    }
                    case EITHER: {
                        g.newEdge(parent, newNode);
                        g.newEdge(newNode, parent);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            parents.add(newNode);
        }
        return parents.isEmpty() ? null : (Node)parents.get(0);
    }

    public static void createRandomBiconnectedGraph(Graph g, int nodes) {
        Generators.createRandomBiconnectedGraph(g, new Random(), nodes);
    }

    public static void createRandomBiconnectedGraph(Graph g, Random random, int nodes) {
        if (nodes < 0) {
            throw new IllegalArgumentException("Negative number of nodes: " + nodes);
        }
        if (nodes == 0) {
            return;
        }
        final ArrayList createdNodes = new ArrayList(nodes);
        EmptyGraphListener nodeListener = new EmptyGraphListener(){

            public void nodeAdded(GraphEvent e) {
                createdNodes.add(e.getNode());
            }
        };
        g.addNodeListener(nodeListener);
        Generators.createRandomTree(g, random, nodes, Direction.OUT);
        g.removeNodeListener(nodeListener);
        Node last = (Node)createdNodes.get(0);
        for (Node node : createdNodes) {
            if (g.outDegree(node) > 0) continue;
            g.newEdge(last, node);
            last = node;
        }
    }

    public static void createRandomDag(Graph g, int nodes, double p) {
        Generators.createRandomDag(g, new Random(), nodes, p);
    }

    public static void createRandomDag(Graph g, Random random, int nodes, double p) {
        Path cycle;
        Generators.createRandom(g, random, nodes, p);
        while ((cycle = Cycles.findCycle(g)) != null) {
            g.removeEdge(cycle.tailEdge());
        }
    }

    public static void createGeneral(Graph g, int ... nodeDegreeDistribution) {
        Generators.createGeneral(g, new Random(), nodeDegreeDistribution);
    }

    public static void createGeneral(Graph g, Random random, int ... nodeDegreeDistribution) {
        Args.notNull((Object)nodeDegreeDistribution);
        Args.isTrue("Sequence is not graphical", Graphs.isSequenceGraphical(nodeDegreeDistribution));
        Node[] nodes = g.newNodes(nodeDegreeDistribution.length);
        Object STUBS = new Object();
        for (int i = 0; i < nodes.length; ++i) {
            Node n = nodes[i];
            n.putWeakly(STUBS, nodeDegreeDistribution[i]);
        }
        for (Node n : nodes) {
            while (n.getInt(STUBS) > g.degree(n)) {
                int index = random.nextInt(nodes.length);
                Node tmp = nodes[index];
                if (tmp.getInt(STUBS) <= g.degree(tmp) || g.areAdjacent(n, tmp)) continue;
                g.newEdge(n, tmp);
            }
        }
    }

    private static class Mapper {
        private final int[] maxPerDimension;

        Mapper(int ... maxPerDimension) {
            this.maxPerDimension = maxPerDimension;
        }

        int pointToIndex(int ... point) {
            int index = 0;
            int unit = 1;
            int dimensionIndex = 0;
            for (int dimension : this.maxPerDimension) {
                index += point[dimensionIndex++] * unit;
                unit *= dimension;
            }
            return index;
        }

        void indexToPoint(int index, int[] point) {
            int pos = 0;
            for (int dimension : this.maxPerDimension) {
                point[pos++] = index % dimension;
                index /= dimension;
            }
        }
    }
}

