/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Clusterer;
import gr.forth.ics.graph.util.FoldingGraph;
import gr.forth.ics.util.Args;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StronglyConnectedComponents
implements Clusterer {
    private final LinkedList<Node> stack = new LinkedList();
    private final List<Collection<Node>> components = new ArrayList<Collection<Node>>();
    private int indexCounter = 0;
    private int componentCounter = 0;
    private final InspectableGraph graph;
    private final Object DATA = new Object();

    private StronglyConnectedComponents(InspectableGraph graph) {
        Args.notNull((Object)graph);
        this.graph = graph;
    }

    static StronglyConnectedComponents execute(InspectableGraph g) {
        return new StronglyConnectedComponents(g).execute();
    }

    public static FoldingGraph fold(Graph graph) {
        Args.notNull((Object)graph);
        FoldingGraph foldingGraph = new FoldingGraph(graph);
        StronglyConnectedComponents scc = StronglyConnectedComponents.execute(graph);
        for (Object cluster : scc.getClusters()) {
            foldingGraph.fold(scc.getCluster(cluster));
        }
        return foldingGraph;
    }

    private StronglyConnectedComponents execute() {
        for (Node n : this.graph.nodes()) {
            if (n.has(this.DATA)) continue;
            this.visit(n);
        }
        return this;
    }

    private void visit(Node u) {
        NodeData uData = new NodeData();
        u.putWeakly(this.DATA, uData);
        uData.root = this.indexCounter;
        uData.index = this.indexCounter++;
        this.stack.addLast(u);
        for (Node w : this.graph.adjacentNodes(u, Direction.OUT)) {
            if (!w.has(this.DATA)) {
                this.visit(w);
            }
            NodeData wData = (NodeData)w.get(this.DATA);
            if (wData.component != null) continue;
            uData.root = Math.min(uData.root, wData.root);
        }
        if (uData.root == uData.index) {
            Node w;
            Integer componentId = this.componentCounter++;
            ArrayList<Node> component = new ArrayList<Node>();
            do {
                w = this.stack.removeLast();
                ((NodeData)w.get((Object)this.DATA)).component = componentId;
                component.add(w);
            } while (w != u);
            this.components.add(component);
        }
    }

    @Override
    public Collection<Object> getClusters() {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                if (index < 0 || index >= this.size()) {
                    throw new IndexOutOfBoundsException("Invalid index: " + index + ", size: " + this.size());
                }
                return index;
            }

            @Override
            public int size() {
                return StronglyConnectedComponents.this.componentCounter;
            }
        };
    }

    @Override
    public Object findClusterOf(Node node) {
        NodeData data = (NodeData)node.get(this.DATA);
        if (data == null) {
            return null;
        }
        return data.component;
    }

    @Override
    public Collection<Node> getCluster(Object key) {
        if (!(key instanceof Integer)) {
            return Collections.emptySet();
        }
        int componentId = (Integer)key;
        if (componentId < 0 || componentId >= this.components.size()) {
            return Collections.emptySet();
        }
        return this.components.get(componentId);
    }

    @Override
    public InspectableGraph getGraph() {
        return this.graph;
    }

    @Override
    public Iterator<Collection<Node>> iterator() {
        return Collections.unmodifiableList(this.components).iterator();
    }

    public String toString() {
        return "[Components: " + this.components + "]";
    }

    private static class NodeData {
        int root;
        int index;
        Object component;

        private NodeData() {
        }
    }
}

