/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.GraphFactory;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.GraphTraversal;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;
import gr.forth.ics.graph.util.Filters;
import java.util.HashSet;

public class Trees {
    private Trees() {
    }

    public static Node findTreeCenter(InspectableGraph tree) {
        if (tree.nodeCount() == 0) {
            return null;
        }
        SecondaryGraph copy = new SecondaryGraph(tree);
        Iterable<Node> leaves = copy.nodes().filter(Filters.degreeEqual(tree, Direction.EITHER, 1));
        while (copy.nodeCount() > 2) {
            HashSet<Node> leafParents = new HashSet<Node>();
            for (Node leaf : leaves) {
                Node parent = copy.aNode(leaf);
                copy.removeNode(leaf);
                if (copy.degree(parent) != 1) continue;
                leafParents.add(parent);
            }
            leaves = leafParents;
        }
        if (copy.nodeCount() == 0) {
            return null;
        }
        return copy.aNode();
    }

    public static Graph fromDag(InspectableGraph dag) {
        return Trees.fromDag(dag, new DagToTreeDuplicator(){

            public void duplicatedNode(Node dagNode, Node treeNode) {
                treeNode.setValue(dagNode);
            }

            public void duplicatedEdge(Edge dagEdge, Edge treeEdge) {
                treeEdge.setValue(dagEdge);
            }
        });
    }

    public static Graph fromDag(InspectableGraph dag, final DagToTreeDuplicator duplicator) {
        final Graph tree = GraphFactory.newGraph();
        for (Node root : dag.nodes()) {
            if (dag.inDegree(root) > 0) continue;
            new GraphTraversal(dag, ExpansionFront.newDFS()).traverse(root, new Visitor(){
                final Object treeNode = new Object();

                public Traversal visit(Path path) {
                    Node n = tree.newNode();
                    path.tailNode().putWeakly(this.treeNode, n);
                    if (duplicator != null) {
                        duplicator.duplicatedNode(path.tailNode(), n);
                    }
                    if (path.size() > 0) {
                        Edge e = tree.newEdge(path.getNode(path.nodeCount() - 2).getNode(this.treeNode), n);
                        if (duplicator != null) {
                            duplicator.duplicatedEdge(path.tailEdge(), e);
                        }
                    }
                    return Traversal.CONTINUE;
                }
            });
        }
        return tree;
    }

    public static interface DagToTreeDuplicator {
        public void duplicatedNode(Node var1, Node var2);

        public void duplicatedEdge(Edge var1, Edge var2);
    }
}

