/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Generators;
import gr.forth.ics.util.Args;
import java.util.List;
import java.util.Random;

class WattsStrogatzGenerator {
    private int numNodes = 0;
    private double rewiringProbability = 0.0;
    private int neighbors = 0;
    private final Random random;

    WattsStrogatzGenerator(Random random, int numNodes, double probability, int neighbors) {
        Args.notNull((Object)random);
        Args.gte((double)numNodes, 2.0);
        Args.inRangeII(Double.valueOf(probability), 0.0, 1.0);
        Args.inRangeII(neighbors, 2, numNodes / 2);
        this.random = random;
        this.numNodes = numNodes;
        this.rewiringProbability = probability;
        this.neighbors = neighbors;
    }

    void generate(Graph graph) {
        Generators.createRingLattice(graph, this.numNodes, this.neighbors);
        List nodes = graph.nodes().drainToList();
        for (int i = 0; i < this.numNodes; ++i) {
            block1: for (int s = 1; s <= this.neighbors; ++s) {
                double r;
                while ((r = this.random.nextDouble()) < this.rewiringProbability) {
                    int v = this.random.nextInt(this.numNodes);
                    Node vthNode = (Node)nodes.get(v);
                    Node ithNode = (Node)nodes.get(i);
                    Node kthNode = (Node)nodes.get((i + s) % this.numNodes);
                    Edge e = graph.anEdge(ithNode, kthNode);
                    if (graph.areAdjacent(kthNode, vthNode) || kthNode == vthNode) continue;
                    graph.removeEdge(e);
                    graph.newEdge(kthNode, vthNode);
                    continue block1;
                }
            }
        }
    }

    private int upIndex(int currentIndex, int numSteps) {
        if (currentIndex + numSteps > this.numNodes - 1) {
            return numSteps - (this.numNodes - currentIndex);
        }
        return currentIndex + numSteps;
    }
}

