/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.algo.transitivity;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Orders;
import gr.forth.ics.graph.algo.transitivity.Closure;
import gr.forth.ics.graph.algo.transitivity.ClosureImpl;
import gr.forth.ics.graph.algo.transitivity.MutableSuccessorSet;
import gr.forth.ics.graph.algo.transitivity.PathFinder;
import gr.forth.ics.graph.algo.transitivity.SuccessorSet;
import gr.forth.ics.graph.algo.transitivity.SuccessorSetFactory;
import gr.forth.ics.graph.concrete.PrimaryGraph;
import java.util.LinkedList;

public class Transitivity {
    private Transitivity() {
    }

    public static Closure acyclicClosure(InspectableGraph g, SuccessorSetFactory successorSetFactory) {
        ClosureImpl closure = new ClosureImpl();
        for (Node n : Orders.reverseTopological(g)) {
            MutableSuccessorSet successors = successorSetFactory.create();
            closure.setSuccessors(n, successors);
            for (Node successor : g.adjacentNodes(n, Direction.OUT)) {
                if (successor == n) continue;
                successors.addAll(closure.successorsOf(successor));
                successors.add(successor);
            }
        }
        return closure;
    }

    public static void acyclicReduction(Graph g, PathFinder pathFinder) {
        for (Node n : Orders.topological(g)) {
            for (Edge e1 : g.edges(n, Direction.OUT)) {
                for (Edge e2 : g.edges(n, Direction.OUT)) {
                    if (e1 == e2 || !pathFinder.pathExists(e1.opposite(n), e2.opposite(n))) continue;
                    g.removeEdge(e2);
                }
            }
        }
    }

    public static void materialize(Graph g, Closure closure) {
        for (Node n : g.nodes()) {
            for (Node s : closure.successorsOf(n)) {
                if (g.areAdjacent(n, s, Direction.OUT)) continue;
                g.newEdge(n, s);
            }
        }
    }

    public static void acyclicClosureSweep(InspectableGraph g, SuccessorSetFactory successorSetFactory, SuccessorsListener listener) {
        Object kidsKey = new Object();
        ClosureImpl closure = new ClosureImpl();
        for (Node n : Orders.reverseTopological(g)) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Kids {
                int kids;
                final /* synthetic */ InspectableGraph val$g;

                Kids(Node node) {
                    this.val$g = node;
                    this.kids = this.val$g.inDegree(n);
                }
            }
            Kids kids = new Kids(n, g);
            n.putWeakly(kidsKey, kids);
            MutableSuccessorSet successors = successorSetFactory.create();
            if (kids.kids > 0) {
                closure.setSuccessors(n, successors);
            }
            for (Node successor : g.adjacentNodes(n, Direction.OUT)) {
                if (successor == n) continue;
                successors.addAll(closure.successorsOf(successor));
                successors.add(successor);
            }
            listener.process(n, successors);
            for (Node successor : g.adjacentNodes(n, Direction.OUT)) {
                Kids successorKids = (Kids)successor.get(kidsKey);
                --successorKids.kids;
                if (successorKids.kids != 0) continue;
                closure.removeSuccessors(successor);
                successor.remove(kidsKey);
            }
        }
    }

    public static Closure generalClosure(InspectableGraph g, SuccessorSetFactory successorSetFactory) {
        new StackTc(g);
        return null;
    }

    public static void main(String[] args) {
        PrimaryGraph graph = new PrimaryGraph();
        Transitivity.create(graph);
        Closure closure = Transitivity.generalClosure(graph, SuccessorSetFactory.hashSetBased());
        for (Node n : graph.nodes()) {
            System.out.println(n + " --> " + closure.successorsOf(n));
        }
    }

    private static void create(Graph graph) {
        Node a = graph.newNode("a");
        Node b = graph.newNode("b");
        Node c = graph.newNode("c");
        Node d = graph.newNode("d");
        Node e = graph.newNode("e");
        Node f = graph.newNode("f");
        Node g = graph.newNode("g");
        Node h = graph.newNode("h");
        Node i = graph.newNode("i");
        Node j = graph.newNode("j");
        graph.newEdge(a, b);
        graph.newEdge(b, a);
        graph.newEdge(b, c);
        graph.newEdge(c, b);
        graph.newEdge(c, d);
        graph.newEdge(a, f);
        graph.newEdge(f, g);
        graph.newEdge(g, f);
        graph.newEdge(g, d);
        graph.newEdge(a, h);
        graph.newEdge(h, i);
        graph.newEdge(i, h);
        graph.newEdge(i, c);
        graph.newEdge(i, e);
        graph.newEdge(i, j);
        graph.newEdge(d, e);
        graph.newEdge(e, d);
    }

    private static class StackTc {
        final InspectableGraph g;
        final Object infoKey = new Object();
        int indexCounter = 0;
        final LinkedList<Node> uStack = new LinkedList();
        final LinkedList<Object> cStack = new LinkedList();

        StackTc(InspectableGraph g) {
            this.g = g;
            for (Node n : g.nodes()) {
                if (n.has(this.infoKey)) continue;
                this.visit(n);
            }
        }

        void visit(Node u) {
            NodeInfo uInfo = new NodeInfo();
            u.putWeakly(this.infoKey, uInfo);
            uInfo.index = this.indexCounter++;
            uInfo.root = uInfo.index;
            this.uStack.push(u);
            uInfo.savedHeight = this.uStack.size();
            for (Node w : this.g.adjacentNodes(u, Direction.OUT)) {
                if (w == u) {
                    uInfo.selfLoop = true;
                    continue;
                }
                if (!w.has(this.infoKey)) {
                    this.visit(w);
                }
                NodeInfo wInfo = (NodeInfo)w.get(this.infoKey);
                if (wInfo.comp == null) {
                    uInfo.root = Math.min(uInfo.root, wInfo.root);
                    continue;
                }
                if (wInfo.comp == uInfo.comp) continue;
                this.cStack.push(wInfo.comp);
            }
            if (uInfo.root == uInfo.root) {
                Object C = new Object();
                if (this.uStack.peekFirst() != u || uInfo.selfLoop) {
                    // empty if block
                }
            }
        }

        private static class NodeInfo {
            int index;
            int root;
            Object comp;
            int savedHeight;
            boolean selfLoop;

            private NodeInfo() {
            }
        }
    }

    public static interface SuccessorsListener {
        public void process(Node var1, SuccessorSet var2);
    }
}

