/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Hint;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.Tuple;
import gr.forth.ics.graph.concrete.TupleImpl;
import gr.forth.ics.graph.event.EdgeListener;
import gr.forth.ics.graph.event.GraphEventSupport;
import gr.forth.ics.graph.event.GraphListener;
import gr.forth.ics.graph.event.NodeListener;
import gr.forth.ics.graph.util.Graphs;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedListIterable;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInspectableGraph
implements InspectableGraph,
Serializable {
    protected transient GraphEventSupport graphEventSupport = new GraphEventSupport();
    protected int edgeCount;
    private final Set<Hint> hints = EnumSet.noneOf(Hint.class);
    private final Tuple tuple = new TupleImpl();

    @Override
    public void hint(Hint hint) {
        Args.notNull((Object)hint);
        this.hints.add(hint);
    }

    protected final boolean containsHint(Hint hint) {
        return this.hints.contains((Object)hint);
    }

    @Override
    public void addGraphListener(GraphListener listener) {
        this.graphEventSupport.addGraphListener(listener);
    }

    @Override
    public void removeGraphListener(GraphListener listener) {
        this.graphEventSupport.removeGraphListener(listener);
    }

    @Override
    public void addNodeListener(NodeListener listener) {
        this.graphEventSupport.addNodeListener(listener);
    }

    @Override
    public void removeNodeListener(NodeListener listener) {
        this.graphEventSupport.removeNodeListener(listener);
    }

    @Override
    public void addEdgeListener(EdgeListener listener) {
        this.graphEventSupport.addEdgeListener(listener);
    }

    @Override
    public void removeEdgeListener(EdgeListener listener) {
        this.graphEventSupport.removeEdgeListener(listener);
    }

    @Override
    public List<NodeListener> getNodeListeners() {
        return this.graphEventSupport.getNodeListeners();
    }

    @Override
    public List<EdgeListener> getEdgeListeners() {
        return this.graphEventSupport.getEdgeListeners();
    }

    @Override
    public Tuple tuple() {
        return this.tuple;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeCount() == 0;
    }

    @Override
    public boolean areAdjacent(Node n1, Node n2) {
        return this.edges(n1, n2).iterator().hasNext();
    }

    @Override
    public boolean areAdjacent(Node n1, Node n2, Direction direction) {
        return this.edges(n1, n2, direction).iterator().hasNext();
    }

    @Override
    public ExtendedListIterable<Edge> edges(Node node) {
        return this.edges(node, Direction.EITHER);
    }

    @Override
    public ExtendedListIterable<Edge> edges(Node n1, Node n2) {
        return this.edges(n1, n2, Direction.EITHER);
    }

    @Override
    public ExtendedListIterable<Node> adjacentNodes(Node n) {
        return this.adjacentNodes(n, Direction.EITHER);
    }

    @Override
    public Edge anEdge() {
        return this.firstEdge(this.edges());
    }

    @Override
    public Edge anEdge(Node node) {
        return this.firstEdge(this.edges(node));
    }

    @Override
    public Edge anEdge(Node node, Direction direction) {
        return this.firstEdge(this.edges(node, direction));
    }

    @Override
    public Edge anEdge(Node n1, Node n2) {
        return this.firstEdge(this.edges(n1, n2));
    }

    @Override
    public Edge anEdge(Node n1, Node n2, Direction direction) {
        return this.firstEdge(this.edges(n1, n2, direction));
    }

    @Override
    public Node aNode() {
        return this.firstNode(this.nodes());
    }

    @Override
    public Node aNode(Node neighbor) {
        return this.firstNode(this.adjacentNodes(neighbor));
    }

    @Override
    public Node aNode(Node neighbor, Direction direction) {
        return this.firstNode(this.adjacentNodes(neighbor, direction));
    }

    private Edge firstEdge(Iterable<Edge> e) {
        Iterator<Edge> edges = e.iterator();
        if (edges.hasNext()) {
            return edges.next();
        }
        throw new NoSuchElementException();
    }

    private Node firstNode(Iterable<Node> n) {
        Iterator<Node> nodes = n.iterator();
        if (nodes.hasNext()) {
            return nodes.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public int degree(Node node) {
        return this.outDegree(node) + this.inDegree(node);
    }

    @Override
    public int degree(Node node, Direction direction) {
        switch (direction) {
            case OUT: {
                return this.outDegree(node);
            }
            case IN: {
                return this.inDegree(node);
            }
        }
        return this.degree(node);
    }

    private void readObject(ObjectInputStream in) throws Exception {
        in.defaultReadObject();
        this.graphEventSupport = new GraphEventSupport();
    }

    public String toString() {
        return Graphs.printPretty(this).toString();
    }

    @Override
    public boolean isIsolated(Node node) {
        return this.degree(node) == 0;
    }
}

