/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.NodeImpl;
import gr.forth.ics.graph.concrete.TupleImpl;
import gr.forth.ics.graph.path.AbstractPath;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.Accessor;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedIterable;
import java.util.Collections;

final class EdgeImpl
extends TupleImpl
implements Edge {
    final NodeImpl n1;
    final NodeImpl n2;
    Accessor<EdgeImpl> outReference;
    Accessor<EdgeImpl> inReference;

    EdgeImpl(NodeImpl n1, NodeImpl n2, Object value) {
        super(value);
        this.n1 = n1;
        this.n2 = n2;
    }

    public NodeImpl n1() {
        return this.n1;
    }

    public NodeImpl n2() {
        return this.n2;
    }

    public boolean isIncident(Node node) {
        return node == this.n1 || node == this.n2;
    }

    public NodeImpl opposite(Node node) {
        if (this.isIncident(node)) {
            if (node == this.n1) {
                return this.n2;
            }
            return this.n1;
        }
        throw new RuntimeException("Edge: " + this + " does not contain node: " + node);
    }

    public boolean isSelfLoop() {
        return this.n1 == this.n2;
    }

    public boolean isIncident(Edge other) {
        Args.notNull((Object)other);
        return this.n1 == other.n1() || this.n1 == other.n2() || this.n2 == other.n1() || this.n2 == other.n2();
    }

    public NodeImpl getIntersection(Edge other) {
        Args.notNull((Object)other);
        if (this.n1 == other.n1() || this.n1 == other.n2()) {
            return this.n1;
        }
        if (this.n2 == other.n1() || this.n2 == other.n2()) {
            return this.n2;
        }
        return null;
    }

    public NodeImpl getIntersection(boolean startFromN1, Edge other) {
        if (startFromN1) {
            return this.getIntersection(other);
        }
        Args.notNull((Object)other);
        if (this.n2 == other.n1() || this.n2 == other.n2()) {
            return this.n2;
        }
        if (this.n1 == other.n1() || this.n1 == other.n2()) {
            return this.n1;
        }
        return null;
    }

    public Path asPath() {
        return this.asPath(this.n1());
    }

    public Path asPath(final Node head) {
        Args.isTrue("Node not contained in edge", this.isIncident(head));
        return new AbstractPath(){
            final Node tail;
            {
                this.tail = EdgeImpl.this.opposite(head);
            }

            @Override
            public Node headNode() {
                return head;
            }

            @Override
            public Edge headEdge() {
                return EdgeImpl.this;
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Node tailNode() {
                return this.tail;
            }

            @Override
            public Edge tailEdge() {
                return EdgeImpl.this;
            }

            @Override
            public ExtendedIterable<Path> steps() {
                return ExtendedIterable.wrap(Collections.singleton(this));
            }

            @Override
            public Path getStep(int index) {
                if (index != 0) {
                    throw new IllegalArgumentException("Illegal index specified");
                }
                return this;
            }

            @Override
            public Node getNode(int index) {
                switch (index) {
                    case 0: {
                        return head;
                    }
                    case 1: {
                        return this.tail;
                    }
                }
                throw new IllegalArgumentException("Illegal index specified");
            }

            @Override
            public Edge getEdge(int index) {
                if (index != 0) {
                    throw new IllegalArgumentException("Illegal index specified");
                }
                return EdgeImpl.this;
            }

            @Override
            public Path slice(int start, int end) {
                switch (start) {
                    case 0: {
                        if (end == 0) {
                            return head.asPath();
                        }
                        if (end != 1) break;
                        return this;
                    }
                    case 1: {
                        if (end != 1) break;
                        return this.tail.asPath();
                    }
                }
                throw new IllegalArgumentException("Illegal indexes specified");
            }

            @Override
            public Path headPath(int steps) {
                if (steps == 1) {
                    return this;
                }
                if (steps == 0) {
                    return head.asPath();
                }
                throw new IllegalArgumentException("Illegal index specified");
            }

            @Override
            public Path tailPath(int steps) {
                if (steps == 1) {
                    return this;
                }
                if (steps == 0) {
                    return this.tail.asPath();
                }
                throw new IllegalArgumentException("Illegal index specified");
            }

            @Override
            public Path reverse() {
                return EdgeImpl.this.asPath(this.tail);
            }
        };
    }

    public String toString() {
        return "{" + this.n1 + "->" + this.n2 + (this.getValue() == null ? "" : ", (" + this.getValue().toString() + ")") + "}";
    }

    public Edge.Orientation testOrientation(Edge other) {
        Args.notNull((Object)other);
        NodeImpl n = this.getIntersection(other);
        if (n == null || this.isSelfLoop() || other.isSelfLoop()) {
            return Edge.Orientation.UNDEFINED;
        }
        int x = 0;
        if (n == this.n2) {
            ++x;
        }
        if (n == other.n2()) {
            ++x;
        }
        switch (x % 2) {
            case 1: {
                return Edge.Orientation.SAME;
            }
        }
        return Edge.Orientation.OPPOSITE;
    }

    public boolean areParallel(Edge other) {
        Args.notNull((Object)other);
        if (this.n1 == other.n1()) {
            return this.n2 == other.n2();
        }
        if (this.n1 == other.n2()) {
            return this.n2 == other.n1();
        }
        return false;
    }
}

