/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.AbstractListGraph;
import gr.forth.ics.graph.concrete.EdgeImpl;
import gr.forth.ics.graph.concrete.NodeImpl;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.event.VetoException;
import gr.forth.ics.util.Accessor;
import gr.forth.ics.util.FastLinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryGraph
extends AbstractListGraph {
    private static final long serialVersionUID = -4941194412829796815L;

    @Override
    protected final FastLinkedList<EdgeImpl> getOutEdges(NodeImpl node) {
        return node.outEdges;
    }

    @Override
    protected final FastLinkedList<EdgeImpl> getInEdges(NodeImpl node) {
        return node.inEdges;
    }

    @Override
    protected final Accessor<NodeImpl> getNodeRef(NodeImpl node) {
        return node.reference;
    }

    @Override
    protected final Accessor<EdgeImpl> getEdgeOutRef(EdgeImpl edge) {
        return edge.outReference;
    }

    @Override
    protected final Accessor<EdgeImpl> getEdgeInRef(EdgeImpl edge) {
        return edge.inReference;
    }

    @Override
    protected final void removeEdgeRefs(EdgeImpl edge) {
        edge.inReference = null;
        edge.outReference = null;
    }

    @Override
    protected final void setNodeRef(NodeImpl node, Accessor<NodeImpl> ref) {
        node.reference = ref;
    }

    @Override
    protected final void setEdgeOutRef(EdgeImpl edge, Accessor<EdgeImpl> ref) {
        edge.outReference = ref;
    }

    @Override
    protected final void setEdgeInRef(EdgeImpl edge, Accessor<EdgeImpl> ref) {
        edge.inReference = ref;
    }

    @Override
    protected final void removeNodeRef(NodeImpl node) {
        node.reference = null;
    }

    @Override
    protected final void initNode(NodeImpl node) {
    }

    @Override
    public final boolean isPrimary() {
        return true;
    }

    @Override
    public boolean reinsertEdge(Edge e) throws VetoException {
        final EdgeImpl edge = (EdgeImpl)e;
        if (this.getEdgeInRef(edge) != null) {
            if (this.containsEdge(e)) {
                return false;
            }
            throw new IllegalArgumentException("Edge must not belong to any graph, to be reinserted to one");
        }
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.EDGE_REINSERTED, edge), new Runnable(){

            public void run() {
                if (!PrimaryGraph.this.containsNode(edge.n1)) {
                    PrimaryGraph.this.reinsertNode(edge.n1);
                }
                if (!PrimaryGraph.this.containsNode(edge.n2)) {
                    PrimaryGraph.this.reinsertNode(edge.n2);
                }
                PrimaryGraph.this.setEdgeOutRef(edge, edge.n1.outEdges.addLast(edge));
                PrimaryGraph.this.setEdgeInRef(edge, edge.n2.inEdges.addLast(edge));
                ++PrimaryGraph.this.edgeCount;
            }
        });
        return true;
    }

    @Override
    public boolean reinsertNode(Node n) throws VetoException {
        final NodeImpl node = (NodeImpl)n;
        if (this.getNodeRef(node) != null) {
            if (this.containsNode(n)) {
                return false;
            }
            throw new IllegalArgumentException("Node must not belong to any graph, to be reinserted to one");
        }
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.NODE_REINSERTED, node), new Runnable(){

            public void run() {
                PrimaryGraph.this.setNodeRef(node, PrimaryGraph.this.nodes.addLast(node));
            }
        });
        return true;
    }
}

