/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.concrete;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.AbstractListGraph;
import gr.forth.ics.graph.concrete.EdgeImpl;
import gr.forth.ics.graph.concrete.NodeImpl;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.event.VetoException;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.Accessor;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.FastLinkedList;
import gr.forth.ics.util.SerializableObject;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondaryGraph
extends AbstractListGraph {
    private static final long serialVersionUID = 2348144112946233116L;
    private final Object nodeDataKey = new SerializableObject();
    private final Object edgeOutRefKey = new SerializableObject();
    private final Object edgeInRefKey = new SerializableObject();

    public SecondaryGraph() {
    }

    public SecondaryGraph(InspectableGraph graph) {
        this.adoptGraph(graph);
    }

    public SecondaryGraph(InspectableGraph graph, Iterable<Node> nodes) {
        Args.notNull(graph, nodes);
        for (Node n : nodes) {
            this.adoptNode(n);
        }
        for (Node n : nodes) {
            for (Edge e : graph.edges(n)) {
                if (!this.containsNode(e.opposite(n))) continue;
                this.adoptEdge(e);
            }
        }
    }

    public SecondaryGraph(Iterable<Node> nodes, Iterable<Edge> edges) {
        if (nodes != null) {
            for (Node n : nodes) {
                this.adoptNode(n);
            }
        }
        if (edges != null) {
            for (Edge e : edges) {
                this.adoptEdge(e);
            }
        }
    }

    @Override
    protected FastLinkedList<EdgeImpl> getOutEdges(NodeImpl node) {
        return ((NodeData)node.get((Object)this.nodeDataKey)).outEdges;
    }

    @Override
    protected FastLinkedList<EdgeImpl> getInEdges(NodeImpl node) {
        return ((NodeData)node.get((Object)this.nodeDataKey)).inEdges;
    }

    @Override
    protected final Accessor<NodeImpl> getNodeRef(NodeImpl node) {
        return ((NodeData)node.get((Object)this.nodeDataKey)).ref;
    }

    @Override
    protected final Accessor<EdgeImpl> getEdgeOutRef(EdgeImpl edge) {
        return (Accessor)edge.get(this.edgeOutRefKey);
    }

    @Override
    protected final Accessor<EdgeImpl> getEdgeInRef(EdgeImpl edge) {
        return (Accessor)edge.get(this.edgeInRefKey);
    }

    @Override
    protected final void removeEdgeRefs(EdgeImpl edge) {
        edge.remove(this.edgeInRefKey);
        edge.remove(this.edgeOutRefKey);
    }

    @Override
    protected final void setNodeRef(NodeImpl node, Accessor<NodeImpl> ref) {
        ((NodeData)node.get((Object)this.nodeDataKey)).ref = ref;
    }

    @Override
    protected final void setEdgeOutRef(EdgeImpl edge, Accessor<EdgeImpl> ref) {
        edge.putWeakly(this.edgeOutRefKey, ref);
    }

    @Override
    protected final void setEdgeInRef(EdgeImpl edge, Accessor<EdgeImpl> ref) {
        edge.putWeakly(this.edgeInRefKey, ref);
    }

    @Override
    protected final void removeNodeRef(NodeImpl node) {
        ((NodeData)node.get((Object)this.nodeDataKey)).ref = null;
    }

    @Override
    protected final void initNode(NodeImpl node) {
        node.putWeakly(this.nodeDataKey, new NodeData());
    }

    @Override
    public final boolean isPrimary() {
        return false;
    }

    public boolean adoptGraph(InspectableGraph graph) throws VetoException {
        Args.notNull((Object)graph);
        boolean changed = this.adoptNodes(graph.nodes());
        return changed |= this.adoptEdges(graph.edges());
    }

    public boolean adoptNode(Node node) throws VetoException {
        Args.notNull((Object)node);
        if (this.containsNode(node)) {
            return false;
        }
        final NodeImpl nodeImpl = (NodeImpl)node;
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.NODE_ADDED, node), new Runnable(){

            public void run() {
                NodeData nodeData = new NodeData();
                nodeData.ref = SecondaryGraph.this.nodes.addLast(nodeImpl);
                nodeImpl.putWeakly(SecondaryGraph.this.nodeDataKey, nodeData);
            }
        });
        return true;
    }

    public boolean adoptEdge(final Edge edge) throws VetoException {
        Args.notNull((Object)edge);
        if (this.containsEdge(edge)) {
            return false;
        }
        this.graphEventSupport.fire(new GraphEvent(this, GraphEvent.Type.EDGE_ADDED, edge), new Runnable(){

            public void run() {
                EdgeImpl edgeImpl = (EdgeImpl)edge;
                SecondaryGraph.this.adoptNode(edgeImpl.n1);
                SecondaryGraph.this.adoptNode(edgeImpl.n2);
                ++SecondaryGraph.this.edgeCount;
                SecondaryGraph.this.setEdgeOutRef(edgeImpl, SecondaryGraph.this.getOutEdges(edgeImpl.n1).addLast(edgeImpl));
                SecondaryGraph.this.setEdgeInRef(edgeImpl, SecondaryGraph.this.getInEdges(edgeImpl.n2).addLast(edgeImpl));
            }
        });
        return true;
    }

    public boolean adoptPath(Path path) throws VetoException {
        return this.adoptEdges(path.edges());
    }

    public boolean adoptNodes(Iterable<Node> nodes) throws VetoException {
        Args.notNull(nodes);
        boolean changed = false;
        for (Node n : nodes) {
            changed |= this.adoptNode(n);
        }
        return changed;
    }

    public boolean adoptEdges(Iterable<Edge> edges) throws VetoException {
        Args.notNull(edges);
        boolean changed = false;
        for (Edge e : edges) {
            changed |= this.adoptEdge(e);
        }
        return changed;
    }

    public boolean removeGraph(InspectableGraph graph) throws VetoException {
        Args.notNull((Object)graph);
        return this.removeNodes(graph.nodes()) != 0;
    }

    public boolean retainGraph(InspectableGraph graph) throws VetoException {
        InspectableGraph other;
        InspectableGraph one;
        Args.notNull((Object)graph);
        boolean changed = false;
        for (Node n : this.nodes()) {
            if (graph.containsNode(n)) continue;
            changed = true;
            this.removeNode(n);
        }
        if (this.edgeCount() > graph.edgeCount()) {
            one = graph;
            other = this;
        } else {
            one = this;
            other = graph;
        }
        for (Edge e : one.edges()) {
            if (other.containsEdge(e)) continue;
            changed = true;
            this.removeEdge(e);
        }
        return changed;
    }

    @Override
    public boolean reinsertNode(Node n) throws VetoException {
        return this.adoptNode(n);
    }

    @Override
    public boolean reinsertEdge(Edge e) throws VetoException {
        return this.adoptEdge(e);
    }

    private static class NodeData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        Accessor<NodeImpl> ref;
        final FastLinkedList<EdgeImpl> inEdges = new FastLinkedList();
        final FastLinkedList<EdgeImpl> outEdges = new FastLinkedList();

        private NodeData() {
        }
    }
}

