/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.event;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import java.util.EventObject;

public class GraphEvent
extends EventObject {
    private final InspectableGraph source;
    private final Type eventType;
    private final Object data;

    public GraphEvent(InspectableGraph source, Type type, Object data) {
        super(source);
        this.source = source;
        this.eventType = type;
        this.data = data;
        type.checkAssignable(data);
    }

    public InspectableGraph getSource() {
        return this.source;
    }

    public Type getEventType() {
        return this.eventType;
    }

    public Object getData() {
        return this.data;
    }

    public Node getNode() {
        return (Node)this.data;
    }

    public Edge getEdge() {
        return (Edge)this.data;
    }

    public int hashCode() {
        return 17 + this.source.hashCode() + this.eventType.hashCode() * 11 + this.data.hashCode() * 37;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GraphEvent)) {
            return false;
        }
        GraphEvent other = (GraphEvent)o;
        return this.source == other.source && this.eventType == other.eventType && this.data == other.data;
    }

    public String toString() {
        return "[Event: source=" + this.source + ", type=" + (Object)((Object)this.eventType) + ", data=" + this.data + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NODE_ADDED(Node.class),
        NODE_REMOVED(Node.class),
        EDGE_ADDED(Edge.class),
        EDGE_REMOVED(Edge.class),
        NODE_REINSERTED(Node.class),
        EDGE_REINSERTED(Edge.class),
        NODE_REORDERED(Node.class),
        EDGE_REORDERED(Edge.class);

        private final Class clazz;

        private Type(Class expectedDataClass) {
            this.clazz = expectedDataClass;
        }

        private void checkAssignable(Object data) {
            this.clazz.cast(data);
        }
    }
}

