/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.event;

import gr.forth.ics.graph.event.EdgeListener;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.event.GraphListener;
import gr.forth.ics.graph.event.NodeListener;
import gr.forth.ics.graph.event.OperationListener;
import gr.forth.ics.graph.event.VetoException;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.EventSupport;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphEventSupport {
    private static final Runnable NULL_RUNNABLE = new Runnable(){

        public void run() {
        }
    };
    private final EventSupport<NodeListener> nodeSupport = new EventSupport();
    private final EventSupport<EdgeListener> edgeSupport = new EventSupport();
    private int listeners;

    private void calcListeners() {
        this.listeners = this.nodeSupport.getListenerCount() + this.edgeSupport.getListenerCount();
    }

    public boolean isEmpty() {
        return this.listeners == 0;
    }

    public void addEdgeListener(EdgeListener listener) {
        this.edgeSupport.addListener(listener);
        this.calcListeners();
    }

    public void addNodeListener(NodeListener listener) {
        this.nodeSupport.addListener(listener);
        this.calcListeners();
    }

    public void removeEdgeListener(EdgeListener listener) {
        this.edgeSupport.removeListener(listener);
        this.calcListeners();
    }

    public void removeNodeListener(NodeListener listener) {
        this.nodeSupport.removeListener(listener);
        this.calcListeners();
    }

    public void addGraphListener(GraphListener listener) {
        this.addEdgeListener(listener);
        this.addNodeListener(listener);
    }

    public void removeGraphListener(GraphListener listener) {
        if (listener == null) {
            return;
        }
        this.removeEdgeListener(listener);
        this.removeNodeListener(listener);
    }

    public void fire(GraphEvent e) throws VetoException {
        this.fire(e, e.getEventType(), NULL_RUNNABLE);
    }

    public void fire(GraphEvent e, Runnable commandIfNoVeto) throws VetoException {
        this.fire(e, e.getEventType(), commandIfNoVeto);
    }

    public void fire(GraphEvent e, GraphEvent.Type eventType, Runnable commandIfNoVeto) throws VetoException {
        if (this.listeners == 0) {
            commandIfNoVeto.run();
            return;
        }
        switch (eventType) {
            case NODE_ADDED: 
            case NODE_REINSERTED: {
                this.fireAddNode(e, commandIfNoVeto);
                break;
            }
            case NODE_REMOVED: {
                this.fireRemoveNode(e, commandIfNoVeto);
                break;
            }
            case EDGE_ADDED: 
            case EDGE_REINSERTED: {
                this.fireAddEdge(e, commandIfNoVeto);
                break;
            }
            case EDGE_REMOVED: {
                this.fireRemoveEdge(e, commandIfNoVeto);
                break;
            }
            case NODE_REORDERED: {
                this.fireNodeReordered(e);
                break;
            }
            case EDGE_REORDERED: {
                this.fireEdgeReordered(e);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected event type: " + (Object)((Object)eventType));
            }
        }
    }

    public void firePreEdge() {
        this.firePre(this.edgeSupport.getListeners());
    }

    public void firePostEdge() {
        this.firePost(this.edgeSupport.getListeners());
    }

    public void firePreNode() {
        this.firePre(this.nodeSupport.getListeners());
    }

    public void firePostNode() {
        this.firePost(this.nodeSupport.getListeners());
    }

    public void fireNodeReordered(GraphEvent e) {
        Args.isTrue(e.getEventType() == GraphEvent.Type.NODE_REORDERED);
        for (NodeListener listener : this.nodeSupport.getListeners()) {
            listener.nodeReordered(e);
        }
    }

    public void fireEdgeReordered(GraphEvent e) {
        Args.isTrue(e.getEventType() == GraphEvent.Type.EDGE_REORDERED);
        for (EdgeListener listener : this.edgeSupport.getListeners()) {
            listener.edgeReordered(e);
        }
    }

    public void fireNodeToBeAdded(GraphEvent e) {
        GraphEvent.Type eventType = e.getEventType();
        Args.isTrue(eventType == GraphEvent.Type.NODE_ADDED || eventType == GraphEvent.Type.NODE_REINSERTED);
        if (this.nodeSupport.isEmpty()) {
            return;
        }
        for (NodeListener listener : this.nodeSupport.getListeners()) {
            listener.nodeToBeAdded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddNode(GraphEvent e, Runnable commandIfNoVeto) throws VetoException {
        this.firePreNode();
        try {
            List<NodeListener> listeners = this.nodeSupport.getListeners();
            for (NodeListener listener : listeners) {
                listener.nodeToBeAdded(e);
            }
            commandIfNoVeto.run();
            for (NodeListener listener : listeners) {
                listener.nodeAdded(e);
            }
        }
        finally {
            this.firePostNode();
        }
    }

    public void fireNodeAdded(GraphEvent e) {
        GraphEvent.Type eventType = e.getEventType();
        Args.isTrue(eventType == GraphEvent.Type.NODE_ADDED || eventType == GraphEvent.Type.NODE_REINSERTED);
        if (this.nodeSupport.isEmpty()) {
            return;
        }
        for (NodeListener listener : this.nodeSupport.getListeners()) {
            listener.nodeAdded(e);
        }
    }

    public void fireNodeToBeRemoved(GraphEvent e) {
        Args.isTrue(e.getEventType() == GraphEvent.Type.NODE_REMOVED);
        if (this.nodeSupport.isEmpty()) {
            return;
        }
        for (NodeListener listener : this.nodeSupport.getListeners()) {
            listener.nodeToBeRemoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveNode(GraphEvent e, Runnable commandIfNoVeto) throws VetoException {
        this.firePreNode();
        try {
            List<NodeListener> listeners = this.nodeSupport.getListeners();
            for (NodeListener listener : listeners) {
                listener.nodeToBeRemoved(e);
            }
            commandIfNoVeto.run();
            for (NodeListener listener : listeners) {
                listener.nodeRemoved(e);
            }
        }
        finally {
            this.firePostNode();
        }
    }

    public void fireNodeRemoved(GraphEvent e) {
        Args.isTrue(e.getEventType() == GraphEvent.Type.NODE_REMOVED);
        if (this.nodeSupport.isEmpty()) {
            return;
        }
        for (NodeListener listener : this.nodeSupport.getListeners()) {
            listener.nodeRemoved(e);
        }
    }

    public void fireEdgeToBeAdded(GraphEvent e) {
        GraphEvent.Type eventType = e.getEventType();
        Args.isTrue(eventType == GraphEvent.Type.EDGE_ADDED || eventType == GraphEvent.Type.EDGE_REINSERTED);
        if (this.edgeSupport.isEmpty()) {
            return;
        }
        for (EdgeListener listener : this.edgeSupport.getListeners()) {
            listener.edgeToBeAdded(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddEdge(GraphEvent e, Runnable commandIfNoVeto) throws VetoException {
        this.firePreEdge();
        try {
            List<EdgeListener> listeners = this.edgeSupport.getListeners();
            for (EdgeListener listener : listeners) {
                listener.edgeToBeAdded(e);
            }
            commandIfNoVeto.run();
            for (EdgeListener listener : listeners) {
                listener.edgeAdded(e);
            }
        }
        finally {
            this.firePostEdge();
        }
    }

    public void fireEdgeAdded(GraphEvent e) {
        GraphEvent.Type eventType = e.getEventType();
        Args.isTrue(eventType == GraphEvent.Type.EDGE_ADDED || eventType == GraphEvent.Type.EDGE_REINSERTED);
        if (this.edgeSupport.isEmpty()) {
            return;
        }
        for (EdgeListener listener : this.edgeSupport.getListeners()) {
            listener.edgeAdded(e);
        }
    }

    public void fireEdgeToBeRemoved(GraphEvent e) {
        Args.isTrue(e.getEventType() == GraphEvent.Type.EDGE_REMOVED);
        if (this.edgeSupport.isEmpty()) {
            return;
        }
        for (EdgeListener listener : this.edgeSupport.getListeners()) {
            listener.edgeToBeRemoved(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveEdge(GraphEvent e, Runnable commandIfNoVeto) throws VetoException {
        this.firePreEdge();
        try {
            List<EdgeListener> listeners = this.edgeSupport.getListeners();
            for (EdgeListener listener : listeners) {
                listener.edgeToBeRemoved(e);
            }
            commandIfNoVeto.run();
            for (EdgeListener listener : listeners) {
                listener.edgeRemoved(e);
            }
        }
        finally {
            this.firePostEdge();
        }
    }

    public void fireEdgeRemoved(GraphEvent e) {
        Args.isTrue(e.getEventType() == GraphEvent.Type.EDGE_REMOVED);
        if (this.edgeSupport.isEmpty()) {
            return;
        }
        for (EdgeListener listener : this.edgeSupport.getListeners()) {
            listener.edgeRemoved(e);
        }
    }

    private void firePre(Collection<? extends OperationListener> listeners) {
        for (OperationListener operationListener : listeners) {
            operationListener.preEvent();
        }
    }

    private void firePost(Collection<? extends OperationListener> listeners) {
        for (OperationListener operationListener : listeners) {
            operationListener.postEvent();
        }
    }

    public List<NodeListener> getNodeListeners() {
        return this.nodeSupport.getListeners();
    }

    public List<EdgeListener> getEdgeListeners() {
        return this.edgeSupport.getListeners();
    }
}

