/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.BasicLocator;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.util.Args;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLocator
extends BasicLocator {
    private final List<Locator> locators = new ArrayList<Locator>(2);
    private final Locator.LocationListener myListener = new MyListener();
    private boolean caching = true;

    public CompositeLocator(Locator ... locators) {
        this(Arrays.asList(locators));
    }

    public CompositeLocator(Iterable<? extends Locator> locators) {
        Args.notNull(locators);
        for (Locator locator : locators) {
            this.addLocator(locator);
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        if (this.caching && !caching) {
            this.flushOldPoints();
        }
        this.caching = caching;
    }

    public final void addLocator(Locator locator) {
        Args.notNull((Object)locator);
        this.locators.add(locator);
        locator.addLocationListener(this.myListener);
    }

    public void removeLocator(Locator locator) {
        this.locators.remove(locator);
        locator.removeLocationListener(this.myListener);
    }

    @Override
    public GPoint getLocation(Node node) {
        GPoint point = super.getLocation(node);
        if (point != null) {
            return point;
        }
        if (this.caching) {
            for (Locator nl : this.locators) {
                point = nl.getLocation(node);
                if (point == null) continue;
                this.setLocation(node, point);
                node.remove(this.LOCATION);
                return super.getLocation(node);
            }
            return null;
        }
        for (Locator nl : this.locators) {
            point = nl.getLocation(node);
            if (point == null) continue;
            return this.calcTransformedPoint(point);
        }
        return null;
    }

    @Override
    public List<GPoint> getBends(Edge edge) {
        List<GPoint> bends = super.getBends(edge);
        if (bends != null) {
            return bends;
        }
        if (this.caching) {
            for (Locator nl : this.locators) {
                bends = nl.getBends(edge);
                if (bends == null) continue;
                this.setBends(edge, bends);
                edge.remove(this.LOCATION);
                return super.getBends(edge);
            }
            return null;
        }
        for (Locator nl : this.locators) {
            bends = nl.getBends(edge);
            if (bends == null) continue;
            return this.calcTransformedBends(bends);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListener
    implements Locator.LocationListener {
        private MyListener() {
        }

        @Override
        public void onNodeLocation(Node node, GPoint location) {
            CompositeLocator.this.removeLocation(node);
        }

        @Override
        public void onEdgeLocation(Edge edge, List<GPoint> bends) {
            CompositeLocator.this.removeBends(edge);
        }

        @Override
        public void transformed() {
            CompositeLocator.this.flushOldPoints();
        }
    }
}

