/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.util.Args;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class GRect {
    private final GPoint topLeft;
    private final GPoint size;

    public GRect(double x, double y, double width, double height) {
        if (width < 0.0) {
            x += width;
            width = -width;
        }
        if (height < 0.0) {
            y += height;
            height = -height;
        }
        this.topLeft = new GPoint(x, y);
        this.size = new GPoint(width, height);
    }

    public GRect(GPoint corner, GPoint size) {
        Args.notNull(corner, size);
        if (size.x < 0.0 || size.y < 0.0) {
            double x = corner.x;
            double y = corner.y;
            double width = size.x;
            double height = size.y;
            if (width < 0.0) {
                x += width;
                width = -width;
            }
            if (height < 0.0) {
                y += height;
                height = -height;
            }
            this.topLeft = new GPoint(x, y);
            this.size = new GPoint(width, height);
            return;
        }
        this.topLeft = corner;
        this.size = size;
    }

    public GRect(Dimension dimension) {
        this(0.0, 0.0, dimension.width, dimension.height);
    }

    public double minX() {
        return this.topLeft.x;
    }

    public double minY() {
        return this.topLeft.y;
    }

    public double width() {
        return this.size.x;
    }

    public double height() {
        return this.size.y;
    }

    public boolean contains(double x, double y) {
        return x >= this.topLeft.x && x <= this.topLeft.x + this.size.x && y >= this.topLeft.y && y <= this.topLeft.y + this.size.y;
    }

    public GPoint corner() {
        return this.topLeft;
    }

    public GPoint size() {
        return this.size;
    }

    public double maxX() {
        return this.width() + this.minX();
    }

    public double maxY() {
        return this.height() + this.minY();
    }

    public boolean contains(GPoint point) {
        return this.contains(point.x, point.y);
    }

    public int hashCode() {
        return this.topLeft.hashCode() + this.size.hashCode();
    }

    public GRect union(GPoint point) {
        return new GRect(this.topLeft.x + point.x, this.topLeft.y + point.y, this.size.x, this.size.y);
    }

    public boolean equals(Object o) {
        if (!(o instanceof GRect)) {
            return false;
        }
        GRect other = (GRect)o;
        return this.topLeft.equals(other.topLeft) && this.size.equals(other.size);
    }

    public GRect transformedBy(AffineTransform trans) {
        throw new UnsupportedOperationException();
    }

    public static GRect wrap(Rectangle2D rect) {
        return new GRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public static GRect wrap(Rectangle rect) {
        return new GRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public String toString() {
        return "[" + this.topLeft + "-" + this.topLeft.add(this.size) + "]";
    }
}

