/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import gr.forth.ics.graph.layout.GPoint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;

public class Geom {
    private Geom() {
    }

    public static GPoint findIntersection(Line2D line, Shape shape) {
        return Geom.findIntersection(line, shape.getPathIterator(null, 1.0));
    }

    public static GPoint findIntersection(Line2D line, PathIterator path) {
        int count = 0;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        while (!path.isDone()) {
            Line2D.Double line2;
            GPoint point;
            double[] coords = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            int type = path.currentSegment(coords);
            x1 = coords[0];
            y1 = coords[1];
            if (type != 4 && count > 0 && (point = Geom.findIntersection(line, line2 = new Line2D.Double(x1, y1, x2, y2))) != null) {
                return point;
            }
            ++count;
            x2 = x1;
            y2 = y1;
            path.next();
        }
        return null;
    }

    public static GPoint findIntersection(Line2D l1, Line2D l2) {
        double y2;
        if (!l1.intersectsLine(l2)) {
            return null;
        }
        if (l1.getX1() == l1.getX2() && l2.getX1() != l2.getX2()) {
            double m2 = (l2.getY1() - l2.getY2()) / (l2.getX1() - l2.getX2());
            double b2 = l2.getY1() - l2.getX1() * m2;
            double y22 = m2 * l1.getX1() + b2;
            return new GPoint(l1.getX1(), y22);
        }
        if (l2.getX1() == l2.getX2() && l1.getX1() != l1.getX2()) {
            double m1 = (l1.getY1() - l1.getY2()) / (l1.getX1() - l1.getX2());
            double b1 = l1.getY1() - l1.getX1() * m1;
            double y1 = m1 * l2.getX1() + b1;
            return new GPoint(l2.getX1(), y1);
        }
        double m1 = (l1.getY1() - l1.getY2()) / (l1.getX1() - l1.getX2());
        double b1 = l1.getY1() - l1.getX1() * m1;
        double m2 = (l2.getY1() - l2.getY2()) / (l2.getX1() - l2.getX2());
        double b2 = l2.getY1() - l2.getX1() * m2;
        double x = (b2 - b1) / (m1 - m2);
        double y1 = m1 * x + b1;
        int diff = (int)(y1 - (y2 = m2 * x + b2));
        if (diff > -1 && diff < 1) {
            return new GPoint(x, y1);
        }
        return null;
    }
}

