/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.CompositeLocator;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.GRect;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.RectBuilder;
import gr.forth.ics.util.Args;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Locators {
    private static final Locator emptyLocator = new Locator(){

        @Override
        public GPoint getLocation(Node node) {
            return null;
        }

        @Override
        public void removeLocation(Node node) {
        }

        @Override
        public void setLocation(Node node, GPoint location) {
        }

        @Override
        public void setLocation(Node node, double x, double y) {
        }

        @Override
        public List<GPoint> getBends(Edge edge) {
            return null;
        }

        @Override
        public List<GPoint> getBendsSafe(Edge edge) {
            return Collections.emptyList();
        }

        @Override
        public void removeBends(Edge edge) {
        }

        @Override
        public void setBend(Edge edge, GPoint singleBend) {
        }

        @Override
        public GPoint getBend(Edge edge) {
            return null;
        }

        @Override
        public void setBends(Edge edge, List<GPoint> bends) {
        }

        @Override
        public void setBends(Edge edge, double[][] bends) {
        }

        @Override
        public AffineTransform getAffineTransform() {
            return new AffineTransform();
        }

        @Override
        public void setAffineTransform(AffineTransform trans) {
        }

        @Override
        public Locator translate(double tx, double ty) {
            return this;
        }

        @Override
        public Locator shear(double sx, double sy) {
            return this;
        }

        @Override
        public Locator rotate(double theta) {
            return this;
        }

        @Override
        public Locator rotate(double theta, double x, double y) {
            return this;
        }

        @Override
        public Locator scale(double sx, double sy) {
            return this;
        }

        @Override
        public void addLocationListener(Locator.LocationListener listener) {
        }

        @Override
        public void removeLocationListener(Locator.LocationListener listener) {
        }

        @Override
        public List<Locator.LocationListener> getLocationListeners() {
            return Collections.emptyList();
        }
    };

    private Locators() {
    }

    public static Locator compose(Locator ... locators) {
        return Locators.compose(Arrays.asList(locators));
    }

    public static Locator compose(Iterable<? extends Locator> locators) {
        return new CompositeLocator(locators);
    }

    public static GRect getBoundingBox(Locator locator, InspectableGraph graph) {
        return Locators.getBoundingBox(locator, graph.nodes(), graph.edges());
    }

    public static GRect getBoundingBox(Locator locator, Iterable<Node> nodes, Iterable<Edge> edges) {
        RectBuilder rectBuilder = new RectBuilder();
        for (Node node : nodes) {
            rectBuilder.add(locator.getLocation(node));
        }
        for (Edge edge : edges) {
            for (GPoint bend : locator.getBendsSafe(edge)) {
                rectBuilder.add(bend);
            }
        }
        return rectBuilder.get();
    }

    public static void zoomToRect(Locator locator, InspectableGraph graph, GRect space) {
        Args.notNull(locator, graph, space);
        locator.setAffineTransform(new AffineTransform());
        GRect bbox = Locators.getBoundingBox(locator, graph);
        double sx = bbox.width() == 0.0 ? 1.0 : bbox.width();
        double sy = bbox.height() == 0.0 ? 1.0 : bbox.height();
        locator.translate(space.minX(), space.minY());
        locator.scale(space.width(), space.height());
        locator.scale(1.0 / sx, 1.0 / sy);
        locator.translate(-bbox.minX(), -bbox.minY());
    }

    public static void copy(Locator from, Locator to, InspectableGraph g) {
        Args.notNull(from, to, g);
        for (Node n : g.nodes()) {
            to.setLocation(n, from.getLocation(n));
        }
        for (Edge e : g.edges()) {
            to.setBends(e, from.getBendsSafe(e));
        }
    }

    public static Locator emptyLocator() {
        return emptyLocator;
    }
}

