/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.circular;

import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.BasicLocator;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.util.Args;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularOrder {
    private final List<Node> order;

    public CircularOrder(List<Node> order) {
        this.order = order;
    }

    public CircularOrder(CircularOrder ... layouts) {
        this.order = new LinkedList<Node>();
        for (CircularOrder layout : layouts) {
            this.order.addAll(layout.getOrder());
        }
    }

    public List<Node> getOrder() {
        return Collections.unmodifiableList(this.order);
    }

    public void append(CircularOrder co) {
        Args.notNull((Object)co);
        this.order.addAll(co.order);
        co.order.clear();
    }

    public Locator getCircleLayout(GPoint center, double r, double startArc, Locator locator) {
        return this.getCircleLayout(center, r, startArc, Math.PI * 2, locator);
    }

    public Locator getCircleLayout(GPoint center, double r, double startArc, double arcLength, Locator locator) {
        Args.notNull("Center point", (Object)center);
        if (locator == null) {
            locator = new BasicLocator();
        }
        if (this.order.isEmpty()) {
            return locator;
        }
        double step = arcLength / (double)this.order.size();
        double currentArc = startArc;
        for (Node n : this.order) {
            locator.setLocation(n, center.add(r * Math.cos(currentArc), r * Math.sin(currentArc)));
            currentArc += step;
        }
        return locator;
    }
}

