/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.forces2d;

import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.forces2d.ForceAggregator;
import gr.forth.ics.util.Args;
import java.awt.geom.Point2D;

public class ForceAggregators {
    private ForceAggregators() {
    }

    public static ForceAggregator simple(Object key) {
        return new Simple(key);
    }

    public static ForceAggregator scaled(ForceAggregator delegate, double scale) {
        return new Scaled(delegate, scale);
    }

    public static ForceAggregator temperature(ForceAggregator delegate, double temperature) {
        return new Temperature(delegate, temperature);
    }

    private static class Temperature
    implements ForceAggregator {
        private final ForceAggregator delegate;
        private double temperature;
        private final double E = 1.0E-6;

        public Temperature(ForceAggregator delegate, double temperature) {
            Args.notNull((Object)delegate);
            this.delegate = delegate;
            this.temperature = temperature;
        }

        public double getTemperature() {
            return this.temperature;
        }

        public void setTemperature(double temperature) {
            this.temperature = temperature;
        }

        public GPoint getForce(Node node) {
            GPoint f = this.delegate.getForce(node);
            double deltaLength = Math.max(1.0E-6, f.length());
            double fx = f.x / deltaLength * Math.min(deltaLength, this.temperature);
            double fy = f.y / deltaLength * Math.min(deltaLength, this.temperature);
            return new GPoint(fx, fy);
        }

        public void addForce(Node node, double x, double y) {
            this.delegate.addForce(node, x, y);
        }
    }

    private static class Scaled
    implements ForceAggregator {
        private final ForceAggregator delegate;
        private double scale;

        public Scaled(ForceAggregator delegate) {
            this(delegate, 1.0);
        }

        public Scaled(ForceAggregator delegate, double scale) {
            Args.notNull((Object)delegate);
            this.delegate = delegate;
            this.scale = scale;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public double getScale() {
            return this.scale;
        }

        public GPoint getForce(Node node) {
            return this.delegate.getForce(node).mul(this.scale);
        }

        public void addForce(Node node, double x, double y) {
            this.delegate.addForce(node, x, y);
        }
    }

    private static class Simple
    implements ForceAggregator {
        private final Object key;

        public Simple(Object key) {
            this.key = key;
        }

        public GPoint getForce(Node node) {
            return GPoint.toGPoint((Point2D)node.get(this.key));
        }

        public void addForce(Node node, double x, double y) {
            Point2D p = (Point2D)node.get(this.key);
            p.setLocation(p.getX() + x, p.getY() + y);
        }
    }
}

