/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.forces2d;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.forces2d.EdgeForce;
import gr.forth.ics.graph.layout.forces2d.Force;
import gr.forth.ics.graph.layout.forces2d.ForceAggregator;
import gr.forth.ics.graph.layout.forces2d.NodeForce;
import gr.forth.ics.graph.layout.forces2d.NodeToNodeForce;
import gr.forth.ics.util.Args;

public class Forces {
    private Forces() {
    }

    public static class ScaledForce
    implements Force {
        private final Force force;
        private double scale;

        public ScaledForce(Force delegate) {
            this(delegate, 1.0);
        }

        public ScaledForce(Force delegate, double scale) {
            Args.notNull((Object)delegate);
            this.force = delegate;
            this.scale = scale;
        }

        public double getScale() {
            return this.scale;
        }

        public void setScale(double scale) {
            this.scale = scale;
        }

        public void apply(InspectableGraph graph, Locator locator, final ForceAggregator forceMap) {
            ForceAggregator wrappedForceMap = new ForceAggregator(){

                public GPoint getForce(Node node) {
                    return forceMap.getForce(node);
                }

                public void addForce(Node node, double x, double y) {
                    forceMap.addForce(node, x * ScaledForce.this.scale, y * ScaledForce.this.scale);
                }
            };
            this.force.apply(graph, locator, wrappedForceMap);
        }
    }

    public static class FRSpring
    extends EdgeForce {
        private double force;
        private double k;
        private static final double E = 1.0E-6;

        public FRSpring() {
            this(40.0);
        }

        public FRSpring(double force) {
            this.setForce(force);
        }

        protected void apply(Edge e, ForceAggregator forceMap) {
            Node n1 = e.n1();
            Node n2 = e.n2();
            GPoint p1 = this.locator.getLocation(n1);
            GPoint p2 = this.locator.getLocation(n2);
            double d = Math.max(1.0E-6, p1.distance(p2));
            double dx = p2.x - p1.x;
            double dy = p2.y - p1.y;
            double f = d * d / this.getForce();
            double fdx = f * dx / d;
            double fdy = f * dy / d;
            forceMap.addForce(n1, fdx, fdy);
            forceMap.addForce(n2, -fdx, -fdy);
        }

        public double getForce() {
            return this.force;
        }

        public void setForce(double lambda) {
            this.force = lambda;
        }
    }

    public static class EadesSpring
    extends EdgeForce {
        private double lambda;
        private double k;

        public EadesSpring() {
            this(10.0);
        }

        public EadesSpring(double lambda) {
            this(lambda, 4.0);
        }

        public EadesSpring(double lambda, double k) {
            this.setLambda(lambda);
            this.setK(k);
        }

        protected void apply(Edge e, ForceAggregator forceMap) {
            GPoint p2;
            Node n1 = e.n1();
            Node n2 = e.n2();
            GPoint p1 = this.locator.getLocation(n1);
            double dist = p1.distance(p2 = this.locator.getLocation(n2));
            if (dist == 0.0) {
                return;
            }
            double v = this.getK() * Math.log(dist / this.getLambda());
            double scaleFactor = v / dist;
            double dx = scaleFactor * (p2.x - p1.x);
            double dy = scaleFactor * (p2.y - p1.y);
            forceMap.addForce(n1, dx, dy);
            forceMap.addForce(n2, -dx, -dy);
        }

        public double getLambda() {
            return this.lambda;
        }

        public void setLambda(double lambda) {
            this.lambda = lambda;
        }

        public double getK() {
            return this.k;
        }

        public void setK(double k) {
            this.k = k;
        }
    }

    public static class NodeRepulsion
    extends NodeToNodeForce {
        private double constant;
        private static final double E = 1.0E-6;

        public NodeRepulsion() {
            this(0.001);
        }

        public NodeRepulsion(double constant) {
            this.constant = constant;
        }

        protected void apply(Node n1, Node n2, ForceAggregator forceMap) {
            GPoint p1 = this.locator.getLocation(n1);
            GPoint p2 = this.locator.getLocation(n2);
            double d = Math.max(1.0E-6, p1.distance(p2));
            double f3 = this.constant * this.constant / d;
            double dx = f3 * (p2.x - p1.x) / d;
            double dy = f3 * (p2.y - p1.y) / d;
            forceMap.addForce(n2, dx, dy);
        }

        public double getConstant() {
            return this.constant;
        }

        public void setConstant(double constant) {
            this.constant = constant;
        }
    }

    public static class Gravity
    extends NodeForce {
        private double constant;
        private final GPoint center;

        public Gravity(GPoint center) {
            this(center, 10.0);
        }

        public Gravity(GPoint center, double constant) {
            Args.notNull((Object)center);
            this.setConstant(constant);
            this.center = center;
        }

        protected void apply(Node n, ForceAggregator forceMap) {
            GPoint p = this.locator.getLocation(n);
            double gdx = p.x - this.center.x;
            double dx = -gdx * Math.abs(gdx) * this.getConstant();
            double gdy = p.y - this.center.y;
            double dy = -gdy * Math.abs(gdy) * this.getConstant();
            forceMap.addForce(n, dx, dy);
        }

        public double getConstant() {
            return this.constant;
        }

        public void setConstant(double constant) {
            this.constant = constant;
        }
    }
}

