/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.layout.random;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.layout.GPoint;
import gr.forth.ics.graph.layout.GRect;
import gr.forth.ics.graph.layout.Layout;
import gr.forth.ics.graph.layout.LayoutProcess;
import gr.forth.ics.graph.layout.Locator;
import gr.forth.ics.graph.layout.SingleStepLayoutProcess;
import gr.forth.ics.util.Args;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public class RandomLayout
implements Layout {
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    private final Random random = new Random();

    public RandomLayout(double width, double height) {
        Args.gte(width, 0.0);
        Args.gte(height, 0.0);
        this.x = 0.0;
        this.y = 0.0;
        this.w = width;
        this.h = height;
    }

    public RandomLayout(GRect rect) {
        Args.notNull((Object)rect);
        this.x = rect.minX();
        this.y = rect.minY();
        this.w = rect.width();
        this.h = rect.height();
    }

    public RandomLayout(Rectangle2D rect) {
        Args.notNull((Object)rect);
        this.x = rect.getX();
        this.y = rect.getY();
        this.w = rect.getWidth();
        this.h = rect.getHeight();
    }

    public LayoutProcess layout(final InspectableGraph graph) {
        Args.notNull((Object)graph);
        return new SingleStepLayoutProcess(){

            protected void stepImpl(Locator locator) {
                for (Node node : graph.nodes()) {
                    locator.setLocation(node, new GPoint(RandomLayout.this.x + RandomLayout.this.random.nextDouble() * RandomLayout.this.w, RandomLayout.this.y + RandomLayout.this.random.nextDouble() * RandomLayout.this.h));
                }
            }
        };
    }
}

