/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.metrics;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.metrics.EdgeMetric;
import gr.forth.ics.graph.metrics.Metrics;
import gr.forth.ics.graph.metrics.NodeMetric;
import gr.forth.ics.graph.metrics.SimpleEdgeMetric;
import gr.forth.ics.graph.metrics.SimpleNodeMetric;
import gr.forth.ics.graph.util.Filters;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.DVMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrandesMetrics {
    private final InspectableGraph graph;
    private SimpleNodeMetric closenessOut;
    private SimpleNodeMetric closenessIn;
    private SimpleNodeMetric normalizedOutCloseness;
    private SimpleNodeMetric normalizedInCloseness;
    private SimpleNodeMetric nodeBetweeness;
    private SimpleNodeMetric normalizedNodeBetweeness;
    private SimpleEdgeMetric edgeBetweeness;
    private SimpleEdgeMetric normalizedEdgeBetweeness;
    private SimpleNodeMetric bridging;
    private SimpleNodeMetric eccentricity;
    private double characteristicPathLength;
    private double networkDegree;
    private double networkCloseness;
    private double checkNode;
    private double networkEdgeBetweenness;
    private double networkDiameter;
    private double networkRadius;
    private boolean isDirected = false;

    private BrandesMetrics(InspectableGraph graph, boolean directed) {
        Args.notNull((Object)graph);
        this.graph = graph;
        this.isDirected = directed;
        this.execute();
    }

    private void execute() {
        Object cC = new Object();
        Object cCIn = new Object();
        Object cB = new Object();
        Object cE = new Object();
        Object cR = new Object();
        Object ecc = new Object();
        Direction dir = this.isDirected ? Direction.OUT : Direction.EITHER;
        for (Node n : this.graph.nodes()) {
            n.putWeakly(cC, 0.0);
            n.putWeakly(cCIn, 0.0);
            n.putWeakly(cB, 0.0);
            n.putWeakly(cR, 0.0);
            n.putWeakly(ecc, 0.0);
        }
        for (Edge e : this.graph.edges()) {
            e.putWeakly(cE, 0.0);
        }
        for (Node n : this.graph.nodes()) {
            LinkedList<Node> S = new LinkedList<Node>();
            Object P = new Object();
            DVMap pMap = DVMap.newHashMapWithLinkedLists();
            Object sigma = new Object();
            Object d = new Object();
            for (Node t : this.graph.nodes()) {
                t.putWeakly(d, -1);
                t.putWeakly(sigma, 0);
            }
            n.putWeakly(d, 0);
            n.putWeakly(sigma, 1);
            LinkedList<Node> Q = new LinkedList<Node>();
            Q.addLast(n);
            while (!Q.isEmpty()) {
                Node u = (Node)Q.removeFirst();
                S.addFirst(u);
                for (Node w : this.graph.adjacentNodes(u, dir)) {
                    int dw = w.getInt(d);
                    int du = u.getInt(d);
                    if (dw < 0) {
                        Q.addLast(w);
                        dw = du + 1;
                        w.putWeakly(d, dw);
                        w.putWeakly(cCIn, w.getInt(cCIn) + dw);
                        this.characteristicPathLength += (double)dw;
                        n.putWeakly(cC, n.getInt(cC) + dw);
                        n.putWeakly(ecc, n.getInt(ecc) < dw ? dw : n.getInt(ecc));
                    }
                    if (dw != du + 1) continue;
                    w.putWeakly(sigma, w.getInt(sigma) + u.getInt(sigma));
                    ((Collection)pMap.get(w)).add(u);
                }
            }
            n.putWeakly(cC, 1.0 / n.getDouble(cC));
            Object delta = new Object();
            for (Node u : this.graph.nodes()) {
                u.putWeakly(delta, 0.0);
            }
            while (!S.isEmpty()) {
                Node w = (Node)S.removeFirst();
                for (Node u : (Collection)pMap.get(w)) {
                    double oldDeltaU = u.getDouble(delta);
                    double fraction = (double)u.getInt(sigma) / (double)w.getInt(sigma);
                    u.putWeakly(delta, oldDeltaU + fraction * (1.0 + w.getDouble(delta)));
                }
                if (w == n) continue;
                w.putWeakly(cB, w.getDouble(cB) + w.getDouble(delta));
            }
            for (Edge e : this.graph.edges()) {
                Node n1 = e.n1();
                Node n2 = e.n2();
                double fraction = (double)n1.getInt(sigma) / (double)n2.getInt(sigma);
                if (n1 == n || n2 == n) continue;
                e.putWeakly(cE, e.getDouble(cE) + fraction * (1.0 + n2.getDouble(cB)));
            }
        }
        int maxx = 0;
        int min = this.graph.nodeCount();
        for (Node f : this.graph.nodes()) {
            f.putWeakly(cCIn, f.getDouble(cCIn) == 0.0 ? 0.0 : 1.0 / f.getDouble(cCIn));
            min = f.getInt(ecc) < min ? f.getInt(ecc) : min;
            maxx = f.getInt(ecc) > maxx ? f.getInt(ecc) : maxx;
        }
        this.networkDiameter = maxx;
        this.networkRadius = min;
        this.eccentricity = new SimpleNodeMetric(ecc);
        this.characteristicPathLength = this.isDirected ? (this.characteristicPathLength /= (double)(this.graph.nodeCount() * (this.graph.nodeCount() - 1))) : (this.characteristicPathLength /= (double)(this.graph.nodeCount() * (this.graph.nodeCount() - 1)) / 2.0);
        double sum = 0.0;
        double max = 0.0;
        NodeMetric normalizedDegreeMetric = Metrics.normalizedDegreeMetric(this.graph);
        for (Node u : this.graph.nodes()) {
            double metric = normalizedDegreeMetric.getValue(u);
            max = max >= metric ? max : metric;
            sum += metric;
        }
        this.networkDegree = ((double)this.graph.nodeCount() * max - sum) / (double)(this.graph.nodeCount() - 2);
        this.closenessOut = new SimpleNodeMetric(cC);
        this.closenessIn = new SimpleNodeMetric(cCIn);
        Object normalizedC = new Object();
        Object normalizedCIn = new Object();
        this.normalizedOutCloseness = new SimpleNodeMetric(normalizedC);
        this.normalizedInCloseness = new SimpleNodeMetric(normalizedCIn);
        sum = 0.0;
        max = 0.0;
        for (Node u : this.graph.nodes()) {
            u.putWeakly(normalizedC, (double)(this.graph.nodeCount() - 1) * this.closenessOut.getValue(u));
            u.putWeakly(normalizedCIn, (double)(this.graph.nodeCount() - 1) * this.closenessIn.getValue(u));
            max = max >= u.getDouble(normalizedC) ? max : u.getDouble(normalizedC);
            sum += u.getDouble(normalizedC);
        }
        this.networkCloseness = ((double)this.graph.nodeCount() * max - sum) / ((double)((this.graph.nodeCount() - 1) * (this.graph.nodeCount() - 2)) / (double)(2 * this.graph.nodeCount() - 3));
        this.nodeBetweeness = new SimpleNodeMetric(cB);
        Object normalizedB = new Object();
        this.normalizedNodeBetweeness = new SimpleNodeMetric(normalizedB);
        double denominator = (this.graph.nodeCount() - 1) * (this.graph.nodeCount() - 2);
        sum = 0.0;
        max = 0.0;
        for (Node u : this.graph.nodes()) {
            u.putWeakly(normalizedB, this.nodeBetweeness.getValue(u) / denominator);
            max = max >= u.getDouble(normalizedB) ? max : u.getDouble(normalizedB);
            sum += u.getDouble(normalizedB);
        }
        this.checkNode = ((double)this.graph.nodeCount() * max - sum) / (double)(this.graph.nodeCount() - 1);
        this.edgeBetweeness = new SimpleEdgeMetric(cE);
        Object normalizedE = new Object();
        this.normalizedEdgeBetweeness = new SimpleEdgeMetric(normalizedE);
        double denomin = (this.graph.nodeCount() - 1) * (this.graph.nodeCount() - 2);
        sum = 0.0;
        max = 0.0;
        for (Edge e : this.graph.edges()) {
            e.putWeakly(normalizedE, this.edgeBetweeness.getValue(e) / denomin);
            max = max >= e.getDouble(normalizedE) ? max : e.getDouble(normalizedE);
            sum += e.getDouble(normalizedE);
        }
        this.networkEdgeBetweenness = ((double)this.graph.nodeCount() * max - sum) / (double)(this.graph.nodeCount() - 1);
        for (Node u : this.graph.nodes()) {
            double denom = 0.0;
            for (Node n : this.graph.adjacentNodes(u)) {
                denom += 1.0 / (double)this.graph.degree(n);
            }
            double BC = 1.0 / (double)this.graph.degree(u) / denom;
            u.putWeakly(cR, this.normalizedNodeBetweeness.getValue(u) * BC);
        }
        this.bridging = new SimpleNodeMetric(cR);
    }

    public Collection<Node> getCenterNodes() {
        ArrayList<Node> col = new ArrayList<Node>();
        for (Node n : this.graph.nodes().filter(Filters.equalProperty(this.eccentricity.getKey(), this.getRadius()))) {
            col.add(n);
        }
        return col;
    }

    public double getDiameter() {
        return this.networkDiameter;
    }

    public double getRadius() {
        return this.networkRadius;
    }

    public double getCharacteristicPathLength() {
        return this.characteristicPathLength;
    }

    public double getNetworkDegreeCentralization() {
        return this.networkDegree;
    }

    public double getNetworkClosenessCentralization() {
        return this.networkCloseness;
    }

    public double getNetworkNodeBetweennessCentralization() {
        return this.checkNode;
    }

    public double getNetworkEdgeBetweenness() {
        return this.networkEdgeBetweenness;
    }

    public NodeMetric getEccentricity() {
        return this.checkNode(this.eccentricity);
    }

    public NodeMetric getCloseness() {
        return this.checkNode(this.closenessOut);
    }

    public NodeMetric getNormalizedCloseness() {
        return this.getNormalizedOutCloseness();
    }

    public NodeMetric getNormalizedInCloseness() {
        return this.checkNode(this.normalizedInCloseness);
    }

    public NodeMetric getNormalizedOutCloseness() {
        return this.checkNode(this.normalizedOutCloseness);
    }

    public NodeMetric getNodeBetweeness() {
        return this.checkNode(this.nodeBetweeness);
    }

    public NodeMetric getNormalizedNodeBetweeness() {
        return this.checkNode(this.normalizedNodeBetweeness);
    }

    public EdgeMetric getEdgeBetweeness() {
        return this.checkEdge(this.edgeBetweeness);
    }

    public EdgeMetric getNormalizedEdgeBetweeness() {
        return this.checkEdge(this.normalizedEdgeBetweeness);
    }

    public NodeMetric getBridging() {
        return this.checkNode(this.bridging);
    }

    private NodeMetric checkNode(NodeMetric metric) {
        if (metric == null) {
            throw new IllegalStateException("Algorithm has not been executed");
        }
        return metric;
    }

    private EdgeMetric checkEdge(EdgeMetric metric) {
        if (metric == null) {
            throw new IllegalStateException("Algorithm has not been executed");
        }
        return metric;
    }

    public static BrandesMetrics execute(InspectableGraph g, boolean directed) {
        return new BrandesMetrics(g, directed);
    }
}

