/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.Tuple;
import gr.forth.ics.graph.path.DefaultPath;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedIterable;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPath
implements Path {
    @Override
    public boolean contains(Path path) {
        return this.find(path) != -1;
    }

    @Override
    public ExtendedIterable<Node> nodes() {
        return new ExtendedIterable<Node>(new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    boolean first = true;
                    final Iterator<Path> stepIterator;
                    {
                        this.stepIterator = AbstractPath.this.steps().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.first || this.stepIterator.hasNext();
                    }

                    @Override
                    public Node next() {
                        if (this.first) {
                            this.first = false;
                            return AbstractPath.this.headNode();
                        }
                        return this.stepIterator.next().tailNode();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public ExtendedIterable<Edge> edges() {
        return new ExtendedIterable<Edge>(new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return new Iterator<Edge>(){
                    final Iterator<Path> stepIterator;
                    {
                        this.stepIterator = AbstractPath.this.steps().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.stepIterator.hasNext();
                    }

                    @Override
                    public Edge next() {
                        return this.stepIterator.next().tailEdge();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    @Override
    public boolean isCycle() {
        return this.headNode() == this.tailNode() && this.size() > 0;
    }

    @Override
    public boolean isEuler() {
        return this.hasDuplicates(this.edges());
    }

    @Override
    public boolean isHamilton() {
        return this.hasDuplicates(this.nodes());
    }

    private boolean hasDuplicates(Iterable<? extends Tuple> iterable) {
        Object tempKey = new Object();
        for (Tuple tuple : iterable) {
            if (tuple.has(tempKey)) {
                return false;
            }
            tuple.putWeakly(tempKey, null);
        }
        return true;
    }

    @Override
    public int edgeCount() {
        return this.size();
    }

    @Override
    public int nodeCount() {
        return this.size() + 1;
    }

    @Override
    public int find(Path path) {
        return this.find(path, 0);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Path other = (Path)o;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.headNode() != other.headNode()) {
            return false;
        }
        Iterator<Path> myIter = this.steps().iterator();
        Iterator<Path> otherIter = other.steps().iterator();
        while (myIter.hasNext()) {
            if (myIter.next().tailEdge() == otherIter.next().tailEdge()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash += 37 * this.headNode().hashCode();
        for (Path p : this.steps()) {
            hash += 31 * p.tailEdge().hashCode();
        }
        return hash;
    }

    @Override
    public int find(Path path, int from) {
        Args.notNull((Object)path);
        List<Path> steps = this.steps().drainToList();
        Node head = this.headNode();
        int len = this.size() - path.size() + 1;
        block0: for (int i = from; i < len; ++i) {
            if (i > 0) {
                head = steps.get(i - 1).tailNode();
            }
            if (head != path.headNode()) continue;
            List<Path> followingSteps = steps.subList(i, i + path.size());
            int j = 0;
            for (Path step : path.steps()) {
                if (!followingSteps.get(j).equals(step)) continue block0;
                ++j;
            }
            return i;
        }
        return -1;
    }

    @Override
    public Path replaceFirst(Path subpath, Path replacement) {
        int index = this.find(subpath);
        if (index != -1) {
            return this.replace(index, index + subpath.size(), replacement);
        }
        return this;
    }

    @Override
    public Path replaceAll(Path subpath, Path replacement) {
        Args.notNull(subpath, replacement);
        Path path = this;
        int index = 0;
        while ((index = path.find(subpath, index)) != -1) {
            path = path.replace(index, index + subpath.size(), replacement);
            index += replacement.size() + 1;
        }
        return path;
    }

    @Override
    public Path[] split(int position) {
        Path[] paths = new Path[]{this.headPath(position), this.tailPath(this.size() - position)};
        return paths;
    }

    protected final void chechReplacementPreconditions(int start, int end, Path replacement) {
        if (start != 0) {
            Args.isTrue("Replacement does not start at the same node as the replaced part", this.getNode(start) == replacement.headNode());
        }
        if (end != this.nodeCount()) {
            Args.isTrue("Replacement does not end at the same node as the replaced part", this.getNode(end) == replacement.tailNode());
        }
    }

    @Override
    public Path append(Path other) {
        return DefaultPath.newPath(this, other);
    }

    @Override
    public Path replace(int start, int end, Path replacement) {
        Path headPath = this.headPath(start);
        Path tailPath = this.tailPath(this.edgeCount() - end);
        if (start == 0) {
            return replacement.append(tailPath);
        }
        if (end == this.size()) {
            return headPath.append(replacement);
        }
        return headPath.append(replacement).append(tailPath);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.headNode().toString());
        for (Path s : this.steps()) {
            boolean inverted = s.headEdge().n2() != s.tailNode();
            sb.append(inverted ? "<--" : "-->");
            sb.append(s.tailNode().toString());
        }
        sb.append(']');
        return sb.toString();
    }
}

