/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.path.Path;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.FastLinkedList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpansionFront {
    protected ExpansionFront() {
    }

    public abstract void addPath(Path var1);

    public abstract boolean hasNext();

    public abstract Path next();

    public abstract void reset();

    public void nextRound() {
    }

    public static ExpansionFront newDFS() {
        return new ExpansionFront(){
            FastLinkedList<Path> paths = new FastLinkedList();
            FastLinkedList<Path> currentRun;

            public void addPath(Path path) {
                this.currentRun.addLast(path);
            }

            public Path next() {
                return this.paths.removeFirst();
            }

            public boolean hasNext() {
                return !this.paths.isEmpty();
            }

            public void reset() {
                this.paths = new FastLinkedList();
                this.currentRun = new FastLinkedList();
            }

            public void nextRound() {
                if (this.currentRun != null) {
                    this.currentRun.append(this.paths);
                    this.paths = this.currentRun;
                }
                this.currentRun = new FastLinkedList();
            }
        };
    }

    public static ExpansionFront newBFS() {
        return new ExpansionFront(){
            final LinkedList<Path> paths = new LinkedList();

            public void addPath(Path path) {
                this.paths.addLast(path);
            }

            public Path next() {
                return this.paths.removeFirst();
            }

            public boolean hasNext() {
                return !this.paths.isEmpty();
            }

            public void reset() {
                this.paths.clear();
            }
        };
    }

    public static ExpansionFront newSortedSearch(final Comparator<? super Path> comparator) {
        Args.notNull(comparator);
        return new ExpansionFront(){
            final SortedSet<Path> paths;
            {
                this.paths = new TreeSet<Path>(comparator);
            }

            public void addPath(Path path) {
                this.paths.add(path);
            }

            public void reset() {
                this.paths.clear();
            }

            public Path next() {
                Iterator iterator = this.paths.iterator();
                Path next = (Path)iterator.next();
                iterator.remove();
                return next;
            }

            public boolean hasNext() {
                return !this.paths.isEmpty();
            }
        };
    }
}

