/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathAccumulator;
import gr.forth.ics.util.Args;

public abstract class Explorer {
    public abstract void explore(InspectableGraph var1, Path var2, PathAccumulator var3);

    public static Explorer newDefaultExplorer() {
        return new DefaultExplorer(Direction.OUT);
    }

    public static Explorer newDefaultExplorer(Direction direction) {
        return new DefaultExplorer(direction);
    }

    public static Explorer newTruncatingExplorer() {
        return Explorer.newTruncatingExplorer(Explorer.newDefaultExplorer());
    }

    public static Explorer newTruncatingExplorer(Explorer explorer) {
        return new TruncatingExplorer(explorer);
    }

    private static class TruncatingExplorer
    extends Explorer {
        private final Explorer delegate;
        private final FilteringAccumulator acc = new FilteringAccumulator();

        TruncatingExplorer(Explorer delegate) {
            Args.notNull((Object)delegate);
            this.delegate = delegate;
        }

        public void explore(InspectableGraph g, Path currentPath, PathAccumulator accumulator) {
            this.acc.delegateAccumulator = accumulator;
            this.delegate.explore(g, currentPath, this.acc);
        }

        private static class FilteringAccumulator
        implements PathAccumulator {
            PathAccumulator delegateAccumulator;

            private FilteringAccumulator() {
            }

            public void addPath(Path path) {
                if (path.size() == 0) {
                    this.delegateAccumulator.addPath(path);
                } else {
                    this.delegateAccumulator.addPath(path.tailPath(1));
                }
            }
        }
    }

    private static final class DefaultExplorer
    extends Explorer {
        final Direction direction;

        DefaultExplorer(Direction direction) {
            Args.notNull((Object)direction);
            this.direction = direction;
        }

        public void explore(InspectableGraph g, Path currentPath, PathAccumulator accumulator) {
            for (Edge e : g.edges(currentPath.tailNode(), this.direction)) {
                Path p = e.asPath();
                if (currentPath.tailNode() != e.n1()) {
                    p = p.reverse();
                }
                accumulator.addPath(currentPath.append(p));
            }
        }
    }
}

