/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.path;

import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.path.ExpansionFront;
import gr.forth.ics.graph.path.GraphTraversal;
import gr.forth.ics.graph.path.Path;
import gr.forth.ics.graph.path.PathFilter;
import gr.forth.ics.graph.path.Traversal;
import gr.forth.ics.graph.path.Visitor;
import java.util.LinkedList;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths {
    private Paths() {
    }

    public static Path newPath(Iterable<Path> paths) {
        LinkedList<Path> list = new LinkedList<Path>();
        for (Path p : paths) {
            list.add(p);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Empty paths given");
        }
        block1: while (list.size() > 1) {
            ListIterator<Path> i = list.listIterator();
            while (i.hasNext()) {
                Path p1 = (Path)i.next();
                if (!i.hasNext()) continue block1;
                i.remove();
                Path p2 = (Path)i.next();
                i.set(p1.append(p2));
            }
        }
        return (Path)list.get(0);
    }

    public static Path find(Node start, final Node target, InspectableGraph graph) {
        final Path[] result = new Path[1];
        new GraphTraversal(graph, ExpansionFront.newDFS(), PathFilter.euler()).traverse(start, new Visitor(){

            public Traversal visit(Path path) {
                if (path.tailNode() == target) {
                    result[0] = path;
                    return Traversal.EXIT;
                }
                return Traversal.CONTINUE;
            }
        });
        return result[0];
    }
}

