/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.util;

import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.algo.Biconnectivity;
import gr.forth.ics.graph.algo.Dfs;
import gr.forth.ics.graph.path.Path;

public class GraphChecker {
    private GraphChecker() {
    }

    public static boolean isTree(InspectableGraph graph) {
        if (graph.nodeCount() == 0) {
            return true;
        }
        CycleChecker dfs = CycleChecker.checkCycle(graph);
        return !dfs.hasCycle() && dfs.getComponentCount() == 1;
    }

    public static boolean isForest(InspectableGraph graph) {
        if (graph.nodeCount() == 0) {
            return true;
        }
        CycleChecker dfs = CycleChecker.checkCycle(graph);
        return !dfs.hasCycle();
    }

    public static boolean isBiconnected(InspectableGraph graph) {
        Biconnectivity bicon = Biconnectivity.execute(graph);
        if (bicon.componentsCount() > 1) {
            return false;
        }
        if (graph.edgeCount() == 0) {
            return true;
        }
        Object component = bicon.componentOf(graph.anEdge());
        for (Edge e : graph.edges()) {
            if (bicon.componentOf(e) == component) continue;
            return false;
        }
        return true;
    }

    public static boolean isAcyclic(InspectableGraph g) {
        return !CycleChecker.checkCycle(g).hasCycle();
    }

    private static class CycleChecker
    extends Dfs {
        private boolean hasCycle;

        private CycleChecker(InspectableGraph g) {
            super(g);
        }

        static CycleChecker checkCycle(InspectableGraph g) {
            CycleChecker checker = new CycleChecker(g);
            checker.execute();
            return checker;
        }

        boolean hasCycle() {
            return this.hasCycle;
        }

        protected boolean visitBackEdge(Path path) {
            this.hasCycle = true;
            return true;
        }
    }
}

