/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.util;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.Graph;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.algo.Clusterers;
import gr.forth.ics.graph.concrete.PrimaryGraph;
import gr.forth.ics.graph.concrete.SecondaryGraph;
import gr.forth.ics.graph.event.EdgeListener;
import gr.forth.ics.graph.event.EmptyGraphListener;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.event.GraphListener;
import gr.forth.ics.graph.event.NodeListener;
import gr.forth.ics.graph.event.VetoException;
import gr.forth.ics.graph.path.Cycles;
import gr.forth.ics.graph.util.GraphCloner;
import gr.forth.ics.graph.util.InspectableGraphDecorator;
import gr.forth.ics.graph.util.InvertedInspectableGraph;
import gr.forth.ics.graph.util.UndirectedInspectableGraph;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedListIterable;
import gr.forth.ics.util.FastLinkedList;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graphs {
    private static final ImmutableEnforcer immutableEnforcer = new ImmutableEnforcer();

    public static boolean isSequenceGraphical(int ... degreeSequence) {
        int sum = 0;
        FastLinkedList<Integer> a = new FastLinkedList<Integer>();
        FastLinkedList m = new FastLinkedList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        for (int i : degreeSequence) {
            sum += i;
            if (map.containsKey(i)) {
                if (!a.contains(i)) {
                    a.addLast(i);
                }
                int times = (Integer)map.get(i);
                map.put(i, ++times);
                continue;
            }
            if (!a.contains(i)) {
                a.addLast(i);
            }
            map.put(i, 1);
        }
        for (int o = 0; o < a.size(); ++o) {
            m.addLast(map.get(a.get(o)));
        }
        if (sum % 2 == 0) {
            for (int k = 1; k <= m.size(); ++k) {
                int n = -1;
                for (int i = 1; i <= k; ++i) {
                    n += ((Integer)m.get(i - 1)).intValue();
                }
                int sum1 = 0;
                for (int b = 0; b < n; ++b) {
                    sum1 += degreeSequence[b];
                }
                int sum2 = 0;
                for (int bb = n; bb < degreeSequence.length; ++bb) {
                    sum2 += Math.min(n, degreeSequence[bb]);
                }
                if (sum1 <= (sum2 += n * (n - 1))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isAcyclic(InspectableGraph g) {
        Args.notNull((Object)g);
        if (g.isEmpty()) {
            return true;
        }
        return Graphs.isAcyclic(g, g.aNode());
    }

    public static boolean isAcyclic(InspectableGraph g, Node root) {
        Args.notNull(g, "graph");
        Args.notNull(root, "root");
        return Cycles.findCycle(g, root) == null;
    }

    public static Set<Node> collectNodes(InspectableGraph graph, Node start, Direction direction) {
        return Graphs.collectNodes(graph, start, direction, new HashSet<Node>());
    }

    public static Set<Node> collectNodes(InspectableGraph graph, Node start, Direction direction, Set<Node> set) {
        Args.notNull(graph, "graph");
        Args.notNull(start, "node");
        Args.notNull(new Object[]{direction, "direction"});
        Args.notNull(set, "set");
        LinkedList<Node> stack = new LinkedList<Node>();
        stack.add(start);
        while (!stack.isEmpty()) {
            Node current = (Node)stack.removeLast();
            for (Node next : graph.adjacentNodes(current, direction)) {
                boolean changed = set.add(next);
                if (!changed) continue;
                stack.addLast(next);
            }
        }
        return set;
    }

    public static Appendable printPretty(InspectableGraph g) {
        return Graphs.printPretty(g, new StringBuilder());
    }

    public static Appendable printPretty(InspectableGraph g, Appendable appendable) {
        Args.notNull("Appendable", (Object)appendable);
        try {
            if (g == null) {
                appendable.append("null");
                return appendable;
            }
            appendable.append("Nodes (count = ").append("" + g.nodeCount()).append("):\n");
            for (Node n : g.nodes()) {
                appendable.append(n.toString()).append('\n');
            }
            appendable.append("\nEdges (count = ").append("" + g.edgeCount()).append("):\n");
            for (Edge e : g.edges()) {
                appendable.append(e.toString()).append('\n');
            }
            return appendable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Appendable printCompact(InspectableGraph g) {
        return Graphs.printCompact(g, new StringBuilder());
    }

    public static Appendable printCompact(InspectableGraph g, Appendable appendable) {
        Args.notNull("Appendable", (Object)appendable);
        try {
            appendable.append("[N={");
            int pos = g.nodeCount();
            for (Node n : g.nodes()) {
                appendable.append(n.toString());
                if (pos > 1) {
                    appendable.append(", ");
                }
                --pos;
            }
            appendable.append("}, E={");
            pos = g.edgeCount();
            for (Edge e : g.edges()) {
                appendable.append(e.toString());
                if (pos > 1) {
                    appendable.append(", ");
                }
                --pos;
            }
            appendable.append("}]");
            return appendable;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InspectableGraph undirected(InspectableGraph graph) {
        Args.notNull((Object)graph);
        if (graph instanceof UndirectedInspectableGraph) {
            return graph;
        }
        return new UndirectedInspectableGraph(graph);
    }

    public static InspectableGraph inverted(InspectableGraph graph) {
        Args.notNull((Object)graph);
        if (graph instanceof InvertedInspectableGraph) {
            ((InvertedInspectableGraph)graph).getDelegateGraph();
        }
        return new InvertedInspectableGraph(graph);
    }

    public static void turnImmutabilityOn(Graph graph) {
        Args.notNull((Object)graph);
        graph.addGraphListener(immutableEnforcer);
    }

    public static void turnImmutabilityOff(Graph graph) {
        Args.notNull((Object)graph);
        graph.removeGraphListener(immutableEnforcer);
    }

    public static void makeSimple(Graph graph) {
        Args.notNull((Object)graph);
        for (Node n : graph.nodes()) {
            HashSet<Node> edges = new HashSet<Node>();
            for (Edge e : graph.edges(n, Direction.OUT)) {
                Node other = e.opposite(n);
                if (edges.contains(other)) {
                    graph.removeEdge(e);
                    continue;
                }
                edges.add(other);
            }
        }
    }

    public static void turnSimplicityOn(Graph graph) {
        Args.notNull((Object)graph);
        NoParallelEnforcer listener = new NoParallelEnforcer(graph);
        graph.addEdgeListener(listener);
    }

    public static void turnSimplicityOff(Graph graph) {
        Args.notNull((Object)graph);
        EdgeListener enforcer = null;
        for (EdgeListener listener : graph.getEdgeListeners()) {
            if (!(listener instanceof NoParallelEnforcer)) continue;
            enforcer = listener;
            break;
        }
        if (enforcer != null) {
            graph.removeEdgeListener(enforcer);
        }
    }

    public static InspectableGraph simpleCopy(InspectableGraph source) {
        return new GraphCloner(true, null, null).copy(source, new PrimaryGraph());
    }

    public static int maxDegree(InspectableGraph g, Direction direction) {
        Args.notNull(new Object[]{g, direction});
        int max = 0;
        for (Node n : g.nodes()) {
            int d = g.degree(n, direction);
            if (max >= d) continue;
            max = d;
        }
        return max;
    }

    public static int maxDegree(InspectableGraph g) {
        return Graphs.maxDegree(g, Direction.EITHER);
    }

    public static int minDegree(InspectableGraph g, Direction direction) {
        Args.notNull(new Object[]{g, direction});
        int min = Integer.MAX_VALUE;
        for (Node n : g.nodes()) {
            int d = g.degree(n, direction);
            if (min <= d) continue;
            min = d;
        }
        return min;
    }

    public static int minDegree(InspectableGraph g) {
        return Graphs.minDegree(g, Direction.EITHER);
    }

    public static InspectableGraph readOnlyView(InspectableGraph graph) {
        return new InspectableGraphDecorator(graph);
    }

    public static GraphListener attachCopycatListener(SecondaryGraph copycat, Graph source) {
        Args.notNull(copycat, source);
        CopycatListener gl = new CopycatListener(copycat);
        source.addGraphListener(gl);
        return gl;
    }

    public static InspectableGraph union(InspectableGraph g1, InspectableGraph g2) {
        Args.notNull(g1, g2);
        SecondaryGraph sg = new SecondaryGraph(g1);
        sg.adoptGraph(g2);
        UnionListener l = new UnionListener(sg);
        l.setGraphs(g1, g2);
        g1.addGraphListener(l);
        g2.addGraphListener(l);
        return sg;
    }

    public static InspectableGraph intersection(InspectableGraph g1, InspectableGraph g2) {
        Args.notNull(g1, g2);
        Args.notNull(g1, g2);
        SecondaryGraph sg = new SecondaryGraph(g1);
        sg.retainGraph(g2);
        IntersectionListener l = new IntersectionListener(sg);
        l.setGraphs(g1, g2);
        g1.addGraphListener(l);
        g2.addGraphListener(l);
        return sg;
    }

    public static InspectableGraph subtraction(InspectableGraph g1, InspectableGraph g2) {
        Args.notNull(g1, g2);
        SecondaryGraph sg = new SecondaryGraph(g1);
        sg.removeGraph(g2);
        SubtractionListener l = new SubtractionListener(sg);
        l.setGraphs(g1, g2);
        g1.addGraphListener(l);
        g2.addGraphListener(l);
        return sg;
    }

    public static InspectableGraph xor(InspectableGraph g1, InspectableGraph g2) {
        Args.notNull(g1, g2);
        int size1 = g1.nodeCount() + g1.edgeCount();
        int size2 = g2.nodeCount() + g2.edgeCount();
        InspectableGraph bigGraph = size1 > size2 ? g1 : g2;
        InspectableGraph smallGraph = bigGraph == g1 ? g2 : g1;
        SecondaryGraph sg = new SecondaryGraph(bigGraph);
        for (Node n : smallGraph.nodes()) {
            if (!bigGraph.containsNode(n)) continue;
            sg.removeNode(n);
        }
        for (Edge e : smallGraph.edges()) {
            if (!bigGraph.containsEdge(e)) continue;
            sg.removeEdge(e);
        }
        XorListener l = new XorListener(sg);
        l.setGraphs(g1, g2);
        g1.addGraphListener(l);
        g2.addGraphListener(l);
        return sg;
    }

    public static boolean equalGraphs(InspectableGraph g1, InspectableGraph g2) {
        Args.notNull(g1, g2);
        if (g1 == g2) {
            return true;
        }
        if (g1.nodeCount() != g2.nodeCount()) {
            return false;
        }
        if (g1.edgeCount() != g2.edgeCount()) {
            return false;
        }
        for (Node n : g1.nodes()) {
            if (g2.containsNode(n)) continue;
            return false;
        }
        for (Edge e : g1.edges()) {
            if (g2.containsEdge(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean isConnected(InspectableGraph graph) {
        Args.notNull((Object)graph);
        return Clusterers.connectedComponents(graph).getClusters().size() <= 1;
    }

    public static NodeListener attachNodeNamer(InspectableGraph g) {
        EmptyGraphListener listener = new EmptyGraphListener(){
            int id = 0;

            public void nodeAdded(GraphEvent e) {
                if (e.getEventType() == GraphEvent.Type.NODE_REINSERTED) {
                    return;
                }
                e.getNode().setValue(this.id++);
            }
        };
        g.addNodeListener(listener);
        return listener;
    }

    private static class XorListener
    extends DualListener {
        XorListener(SecondaryGraph g) {
            super(g);
        }

        public void nodeAdded(GraphEvent e) {
            Node n = e.getNode();
            int count = 0;
            if (this.g1.containsNode(n)) {
                ++count;
            }
            if (this.g2.containsNode(n)) {
                ++count;
            }
            if (count == 2) {
                this.g.removeNode(n);
                return;
            }
            this.g.adoptNode(n);
        }

        public void nodeRemoved(GraphEvent e) {
            Node n = e.getNode();
            if (this.g.containsNode(n)) {
                this.g.removeNode(n);
            } else {
                this.g.adoptNode(n);
                InspectableGraph other = e.getSource() == this.g1 ? this.g2 : this.g1;
                for (Edge edge : other.edges(n)) {
                    if (!this.g.containsNode(edge.opposite(n))) continue;
                    this.g.adoptEdge(edge);
                }
            }
        }

        public void edgeAdded(GraphEvent ev) {
            Edge e = ev.getEdge();
            int count = 0;
            if (this.g1.containsEdge(e)) {
                ++count;
            }
            if (this.g2.containsEdge(e)) {
                ++count;
            }
            if (count == 2) {
                this.g.removeEdge(e);
                return;
            }
            if (this.g.containsNode(e.n1()) && this.g.containsNode(e.n2())) {
                this.g.adoptEdge(e);
            }
        }

        public void edgeRemoved(GraphEvent ev) {
            Edge e = ev.getEdge();
            if (this.g.containsEdge(e)) {
                this.g.removeEdge(e);
            } else if (this.g.containsNode(e.n1()) && this.g.containsNode(e.n2())) {
                this.g.adoptEdge(e);
            }
        }
    }

    private static class SubtractionListener
    extends DualListener {
        SubtractionListener(SecondaryGraph g) {
            super(g);
        }

        public void nodeAdded(GraphEvent e) {
            Node n = e.getNode();
            InspectableGraph source = e.getSource();
            if (source == this.g2) {
                this.g.removeNode(n);
            } else if (!this.g2.containsNode(n)) {
                this.g.adoptNode(n);
            }
        }

        public void nodeRemoved(GraphEvent e) {
            Node n = e.getNode();
            InspectableGraph source = e.getSource();
            if (source == this.g1) {
                this.g.removeNode(n);
            } else if (this.g1.containsNode(n)) {
                this.g.adoptNode(n);
                this.g.adoptEdges(this.g1.edges(n));
            }
        }

        public void edgeAdded(GraphEvent ev) {
            Edge e = ev.getEdge();
            InspectableGraph source = ev.getSource();
            if (source == this.g2) {
                this.g.removeEdge(e);
            } else if (!this.g2.containsEdge(e)) {
                this.g.adoptEdge(e);
            }
        }

        public void edgeRemoved(GraphEvent ev) {
            Edge e = ev.getEdge();
            InspectableGraph source = ev.getSource();
            if (source == this.g1) {
                this.g.removeEdge(e);
            } else if (this.g1.containsEdge(e)) {
                this.g.adoptEdge(e);
            }
        }
    }

    private static class UnionListener
    extends DualListener {
        UnionListener(SecondaryGraph g) {
            super(g);
        }

        public void nodeAdded(GraphEvent e) {
            this.g.adoptNode(e.getNode());
        }

        public void nodeRemoved(GraphEvent e) {
            Node n = e.getNode();
            int count = 0;
            if (this.g1.containsNode(n)) {
                ++count;
            }
            if (this.g2.containsNode(n)) {
                ++count;
            }
            if (count == 1) {
                return;
            }
            this.g.removeNode(n);
        }

        public void edgeAdded(GraphEvent e) {
            this.g.adoptEdge(e.getEdge());
        }

        public void edgeRemoved(GraphEvent ev) {
            Edge e = ev.getEdge();
            int count = 0;
            if (this.g1.containsEdge(e)) {
                ++count;
            }
            if (this.g2.containsEdge(e)) {
                ++count;
            }
            if (count == 1) {
                return;
            }
            this.g.removeEdge(e);
        }
    }

    private static class IntersectionListener
    extends DualListener {
        IntersectionListener(SecondaryGraph g) {
            super(g);
        }

        public void nodeAdded(GraphEvent e) {
            Node n = e.getNode();
            if (!this.g1.containsNode(n) || !this.g2.containsNode(n)) {
                return;
            }
            this.g.adoptNode(n);
        }

        public void nodeRemoved(GraphEvent e) {
            this.g.removeNode(e.getNode());
        }

        public void edgeAdded(GraphEvent ev) {
            Edge e = ev.getEdge();
            if (!this.g1.containsEdge(e) || !this.g2.containsEdge(e)) {
                return;
            }
            this.g.adoptEdge(e);
        }

        public void edgeRemoved(GraphEvent ev) {
            this.g.removeEdge(ev.getEdge());
        }
    }

    private static abstract class DualListener
    extends EmptyGraphListener {
        protected final SecondaryGraph g;
        protected InspectableGraph g1;
        protected InspectableGraph g2;

        DualListener(SecondaryGraph g) {
            this.g = g;
        }

        void setGraphs(InspectableGraph g1, InspectableGraph g2) {
            this.g1 = g1;
            this.g2 = g2;
        }
    }

    private static class CopycatListener
    extends EmptyGraphListener {
        private final SecondaryGraph target;

        CopycatListener(SecondaryGraph target) {
            this.target = target;
        }

        public void nodeAdded(GraphEvent e) {
            this.target.adoptNode(e.getNode());
        }

        public void nodeRemoved(GraphEvent e) {
            this.target.removeNode(e.getNode());
        }

        public void edgeAdded(GraphEvent e) {
            this.target.adoptEdge(e.getEdge());
        }

        public void edgeRemoved(GraphEvent e) {
            this.target.removeEdge(e.getEdge());
        }
    }

    private static class NoParallelEnforcer
    extends EmptyGraphListener {
        private final Graph graph;

        NoParallelEnforcer(Graph graph) {
            Args.notNull((Object)graph);
            this.graph = graph;
        }

        public void edgeAdded(GraphEvent ev) {
            Edge edge = ev.getEdge();
            Node n1 = edge.n1();
            Node n2 = edge.n2();
            ExtendedListIterable<Edge> edges = this.graph.outDegree(n1) < this.graph.inDegree(n2) ? this.graph.edges(n1, n2, Direction.OUT) : this.graph.edges(n2, n1, Direction.IN);
            for (Edge e : edges) {
                if (e == edge) continue;
                this.graph.removeEdge(e);
                return;
            }
        }
    }

    private static class ImmutableEnforcer
    extends EmptyGraphListener {
        private static final String msg = "Graph is immutable";

        private ImmutableEnforcer() {
        }

        public void nodeToBeAdded(GraphEvent e) throws VetoException {
            throw new VetoException(msg);
        }

        public void nodeToBeRemoved(GraphEvent e) throws VetoException {
            throw new VetoException(msg);
        }

        public void edgeToBeAdded(GraphEvent e) throws VetoException {
            throw new VetoException(msg);
        }

        public void edgeToBeRemoved(GraphEvent e) throws VetoException {
            throw new VetoException(msg);
        }
    }
}

