/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.graph.util;

import gr.forth.ics.graph.Direction;
import gr.forth.ics.graph.Edge;
import gr.forth.ics.graph.InspectableGraph;
import gr.forth.ics.graph.Node;
import gr.forth.ics.graph.concrete.AbstractInspectableGraph;
import gr.forth.ics.graph.event.EdgeListener;
import gr.forth.ics.graph.event.GraphEvent;
import gr.forth.ics.graph.event.GraphEventSupport;
import gr.forth.ics.graph.event.GraphListener;
import gr.forth.ics.graph.event.NodeListener;
import gr.forth.ics.graph.event.VetoException;
import gr.forth.ics.util.Args;
import gr.forth.ics.util.ExtendedListIterable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectableGraphDecorator
extends AbstractInspectableGraph
implements InspectableGraph,
Serializable {
    protected final InspectableGraph inspectableGraph;
    private final GraphEventSupport eventSupport = new GraphEventSupport();
    protected NodeListener nodeListener;
    protected EdgeListener edgeListener;

    public InspectableGraphDecorator(InspectableGraph delegate) {
        Args.notNull((Object)delegate);
        this.inspectableGraph = delegate;
    }

    public InspectableGraph getDelegateGraph() {
        return this.inspectableGraph;
    }

    private void lazyInitNodeListener() {
        if (this.nodeListener == null) {
            this.nodeListener = new TrampolineNodeListener(this, this.inspectableGraph);
            this.inspectableGraph.addNodeListener(this.nodeListener);
        }
    }

    private void lazyInitEdgeListener() {
        if (this.edgeListener == null) {
            this.edgeListener = new TrampolineEdgeListener(this, this.inspectableGraph);
            this.inspectableGraph.addEdgeListener(this.edgeListener);
        }
    }

    @Override
    public void addGraphListener(GraphListener listener) {
        this.eventSupport.addGraphListener(listener);
        this.lazyInitNodeListener();
        this.lazyInitEdgeListener();
    }

    @Override
    public void removeGraphListener(GraphListener listener) {
        this.eventSupport.removeGraphListener(listener);
    }

    @Override
    public void addNodeListener(NodeListener listener) {
        this.eventSupport.addNodeListener(listener);
        this.lazyInitNodeListener();
    }

    @Override
    public void removeNodeListener(NodeListener listener) {
        this.eventSupport.removeNodeListener(listener);
    }

    @Override
    public void addEdgeListener(EdgeListener listener) {
        this.eventSupport.addEdgeListener(listener);
        this.lazyInitEdgeListener();
    }

    @Override
    public void removeEdgeListener(EdgeListener listener) {
        this.eventSupport.removeEdgeListener(listener);
    }

    @Override
    public List<NodeListener> getNodeListeners() {
        return this.eventSupport.getNodeListeners();
    }

    @Override
    public List<EdgeListener> getEdgeListeners() {
        return this.eventSupport.getEdgeListeners();
    }

    @Override
    public ExtendedListIterable<Node> adjacentNodes(Node node, Direction direction) {
        return this.inspectableGraph.adjacentNodes(node, direction);
    }

    @Override
    public int nodeCount() {
        return this.inspectableGraph.nodeCount();
    }

    @Override
    public int edgeCount() {
        return this.inspectableGraph.edgeCount();
    }

    @Override
    public ExtendedListIterable<Node> nodes() {
        return this.inspectableGraph.nodes();
    }

    @Override
    public ExtendedListIterable<Edge> edges(Node node, Direction direction) {
        return this.inspectableGraph.edges(node, direction);
    }

    @Override
    public ExtendedListIterable<Edge> edges(Node n1, Node n2, Direction direction) {
        return this.inspectableGraph.edges(n1, n2, direction);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.inspectableGraph.containsEdge(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.inspectableGraph.containsNode(node);
    }

    @Override
    public int inDegree(Node node) {
        return this.inspectableGraph.inDegree(node);
    }

    @Override
    public int outDegree(Node node) {
        return this.inspectableGraph.outDegree(node);
    }

    @Override
    public ExtendedListIterable<Edge> edges() {
        return this.inspectableGraph.edges();
    }

    @Override
    public boolean isIsolated(Node node) {
        return this.inspectableGraph.degree(node) == 0;
    }

    private static class TrampolineEdgeListener
    extends Detached
    implements EdgeListener {
        TrampolineEdgeListener(InspectableGraphDecorator gd, InspectableGraph source) {
            super(gd, source);
        }

        public void edgeToBeAdded(GraphEvent e) {
            this.eventSupport.fireEdgeToBeAdded(this.deriveEvent(e));
        }

        public void edgeReordered(GraphEvent e) {
        }

        public void edgeRemoved(GraphEvent e) {
            this.eventSupport.fireEdgeRemoved(this.deriveEvent(e));
        }

        public void edgeAdded(GraphEvent e) {
            this.eventSupport.fireEdgeAdded(this.deriveEvent(e));
        }

        public void edgeToBeRemoved(GraphEvent e) throws VetoException {
            this.eventSupport.fireEdgeToBeRemoved(this.deriveEvent(e));
        }

        protected void removeSelf(InspectableGraph target) {
            target.removeEdgeListener(this);
        }

        protected void preEventImpl() {
            this.eventSupport.firePreEdge();
        }

        protected void postEventImpl() {
            this.eventSupport.firePostEdge();
        }
    }

    private static class TrampolineNodeListener
    extends Detached
    implements NodeListener {
        TrampolineNodeListener(InspectableGraphDecorator gd, InspectableGraph source) {
            super(gd, source);
        }

        public void nodeToBeRemoved(GraphEvent e) {
            this.eventSupport.fireNodeToBeRemoved(this.deriveEvent(e));
        }

        public void nodeToBeAdded(GraphEvent e) {
            this.eventSupport.fireNodeToBeAdded(this.deriveEvent(e));
        }

        public void nodeRemoved(GraphEvent e) {
            this.eventSupport.fireNodeRemoved(this.deriveEvent(e));
        }

        public void nodeAdded(GraphEvent e) {
            this.eventSupport.fireNodeAdded(this.deriveEvent(e));
        }

        public void nodeReordered(GraphEvent e) {
        }

        protected void removeSelf(InspectableGraph target) {
            target.removeNodeListener(this);
        }

        protected void preEventImpl() {
            this.eventSupport.firePreNode();
        }

        protected void postEventImpl() {
            this.eventSupport.firePostNode();
        }
    }

    private static abstract class Detached {
        private final WeakReference<InspectableGraphDecorator> ref;
        private final InspectableGraph target;
        private InspectableGraphDecorator gd;
        protected GraphEventSupport eventSupport;
        private int depth = 0;

        Detached(InspectableGraphDecorator gd, InspectableGraph target) {
            this.ref = new WeakReference<InspectableGraphDecorator>(gd);
            this.target = target;
        }

        protected abstract void removeSelf(InspectableGraph var1);

        protected abstract void preEventImpl();

        protected abstract void postEventImpl();

        public final void preEvent() {
            ++this.depth;
            this.gd = (InspectableGraphDecorator)this.ref.get();
            if (this.gd == null) {
                this.removeSelf(this.target);
                return;
            }
            this.eventSupport = this.gd.eventSupport;
            this.preEventImpl();
        }

        public final void postEvent() {
            --this.depth;
            this.postEventImpl();
            if (this.depth == 0) {
                this.eventSupport = null;
                this.gd = null;
            }
        }

        protected GraphEvent deriveEvent(GraphEvent e) {
            return new GraphEvent((InspectableGraph)this.ref.get(), e.getEventType(), e.getData());
        }
    }
}

