/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Args;
import gr.forth.ics.util.Exceptions;
import gr.forth.ics.util.Factory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstanceFactory<T>
implements Factory<T> {
    private final Class<T> clazz;

    public static <T> ClassInstanceFactory<T> from(Class<T> clazz) {
        return new ClassInstanceFactory<T>(clazz);
    }

    public ClassInstanceFactory(Class<T> clazz) {
        Args.notNull(clazz);
        this.clazz = clazz;
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException("Class: " + clazz + " is abstract");
        }
        Constructor<T> c = null;
        try {
            c = clazz.getConstructor(new Class[0]);
        }
        catch (SecurityException ex) {
            throw Exceptions.asUnchecked(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Class: " + clazz + "" + " does not define an empty accessible constructor");
        }
        if (!Modifier.isPublic(c.getModifiers())) {
            throw new IllegalArgumentException("Class: " + clazz + "" + " does not define an empty public constructor");
        }
    }

    @Override
    public T create(Object o) {
        try {
            return this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw Exceptions.asUnchecked(e.getCause());
        }
        catch (Exception e) {
            throw (AssertionError)((Object)((Throwable)((Object)new AssertionError())).initCause(e));
        }
    }
}

