/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Copyable;
import gr.forth.ics.util.Factory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DVMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;
    private final Factory<V> factory;

    public DVMap(Map<K, V> delegate, Factory<V> factory) {
        if (delegate == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.delegate = delegate;
        this.factory = factory;
    }

    public DVMap(Factory<V> factory) {
        this(new HashMap(), factory);
    }

    public DVMap(final Copyable<? extends V> defaultValue) {
        this(new Factory<V>(){

            @Override
            public V create(Object o) {
                return defaultValue.copy();
            }
        });
    }

    public DVMap(final V defaultValue) {
        this(new Factory<V>(){

            @Override
            public V create(Object o) {
                return defaultValue;
            }
        });
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Map<K, V> getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V get(Object key) {
        if (!this.delegate.containsKey(key)) {
            V value = this.factory.create(key);
            this.delegate.put(key, value);
            return value;
        }
        return this.delegate.get(key);
    }

    public V getIfExists(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.delegate.putAll(map);
    }

    @Override
    public V remove(Object key) {
        V v = this.delegate.remove(key);
        if (v == null) {
            return this.factory.create(key);
        }
        return v;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static <K, V> DVMap<K, Collection<V>> newHashMapWithLinkedLists() {
        return new DVMap(new HashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new LinkedList();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newHashMapWithArrayLists() {
        return new DVMap(new HashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new ArrayList();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newHashMapWithHashSets() {
        return new DVMap(new HashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new HashSet();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newHashMapWithTreeSets(final Comparator<V> c) {
        return new DVMap(new HashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new TreeSet(c);
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newHashMapWithTreeSets() {
        return new DVMap(new HashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new TreeSet();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newTreeMapWithLinkedLists() {
        return new DVMap(new TreeMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new LinkedList();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newTreeMapWithArrayLists() {
        return new DVMap(new TreeMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new ArrayList();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newTreeMapWithHashSets() {
        return new DVMap(new TreeMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new HashSet();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newTreeMapWithTreeSets(final Comparator<V> c) {
        return new DVMap(new TreeMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new TreeSet(c);
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newTreeMapWithTreeSets() {
        return new DVMap(new TreeMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new TreeSet();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newLinkedHashMapWithLinkedLists() {
        return new DVMap(new LinkedHashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new LinkedList();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newLinkedHashMapWithArrayLists() {
        return new DVMap(new LinkedHashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new ArrayList();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newLinkedHashMapWithHashSets() {
        return new DVMap(new LinkedHashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new HashSet();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newLinkedHashMapWithLinkedHashSets() {
        return new DVMap(new HashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new LinkedHashSet();
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newLinkedHashMapWithTreeSets(final Comparator<V> c) {
        return new DVMap(new LinkedHashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new TreeSet(c);
            }
        });
    }

    public static <K, V> DVMap<K, Collection<V>> newLinkedHashMapWithTreeSets() {
        return new DVMap(new LinkedHashMap(), new Factory<Collection<V>>(){

            @Override
            public Collection<V> create(Object o) {
                return new TreeSet();
            }
        });
    }
}

