/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSupport<L> {
    private List<L> listeners = null;

    public List<L> getListeners() {
        return this.listeners != null ? Collections.unmodifiableList(this.listeners) : Collections.emptyList();
    }

    private void lazyInit() {
        if (this.listeners == null) {
            this.listeners = new InverseArrayList();
        }
    }

    public void addListener(L listener) {
        if (listener == null) {
            return;
        }
        this.lazyInit();
        this.listeners.add(listener);
    }

    public void removeListener(L listener) {
        if (listener == null || this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public int getListenerCount() {
        if (this.listeners == null) {
            return 0;
        }
        return this.listeners.size();
    }

    public boolean isEmpty() {
        if (this.listeners == null) {
            return true;
        }
        return this.listeners.isEmpty();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InverseArrayList<L>
    extends ArrayList<L> {
        private InverseArrayList() {
        }

        @Override
        public Iterator<L> iterator() {
            return new Iterator<L>(){
                int pos;
                {
                    this.pos = InverseArrayList.this.size() - 1;
                }

                @Override
                public boolean hasNext() {
                    return this.pos >= 0;
                }

                @Override
                public L next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return InverseArrayList.this.get(this.pos--);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

