/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedSet<T>
extends AbstractCollection<T>
implements Set<T> {
    private final List<T> list = new ArrayList<T>();
    private final Set<T> set = new HashSet<T>();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Iterator<T> realIterator;
            T current;
            {
                this.realIterator = IndexedSet.this.list.iterator();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.realIterator.hasNext();
            }

            @Override
            public T next() {
                Object next = this.realIterator.next();
                this.current = next;
                return next;
            }

            @Override
            public void remove() {
                this.realIterator.remove();
                IndexedSet.this.set.remove(this.current);
                this.current = null;
            }
        };
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        boolean added = this.set.add(e);
        if (added) {
            this.list.add(e);
        }
        return added;
    }

    @Override
    public boolean remove(Object o) {
        boolean removed = this.set.remove(o);
        if (removed) {
            this.list.remove(o);
        }
        return removed;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean removed = false;
        Iterator<T> it = this.list.iterator();
        while (it.hasNext()) {
            T next = it.next();
            if (c.contains(next)) continue;
            it.remove();
            this.set.remove(it);
            removed = true;
        }
        return removed;
    }

    @Override
    public void clear() {
        this.set.clear();
        this.list.clear();
    }

    public T get(int index) {
        return this.list.get(index);
    }

    public T remove(int index) {
        T t = this.list.get(index);
        this.remove(t);
        return t;
    }
}

