/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Permutator {
    private Permutator() {
    }

    public static <T> Iterable<List<T>> permutations(final List<T> list) {
        return new Iterable<List<T>>(){

            @Override
            public Iterator<List<T>> iterator() {
                return new Iterator<List<T>>(){
                    private int current = 0;
                    private final long length;
                    {
                        this.length = Permutator.factorial(list.size());
                    }

                    @Override
                    public List<T> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ArrayList permutation = new ArrayList(list);
                        int k = this.current;
                        for (int j = 2; j <= list.size(); ++j) {
                            Collections.swap(permutation, (k /= j - 1) % j, j - 1);
                        }
                        ++this.current;
                        return permutation;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return (long)this.current < this.length;
                    }
                };
            }
        };
    }

    private static long factorial(int k) {
        long factorial = 1L;
        for (int i = 2; i <= k; ++i) {
            factorial *= (long)i;
        }
        return factorial;
    }
}

