/*
 * Decompiled with CFR 0.152.
 */
package gr.forth.ics.util;

import gr.forth.ics.util.Args;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushBackIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private E saved = null;
    private E last;

    public PushBackIterator(Iterator<E> iterator) {
        Args.notNull(iterator);
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.saved != null || this.iterator.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        if (this.saved != null) {
            try {
                this.last = this.saved;
                E e = this.last;
                return e;
            }
            finally {
                this.saved = null;
            }
        }
        this.last = this.iterator.next();
        return this.last;
    }

    public void pushBack() {
        this.saved = this.last;
    }

    @Override
    public void remove() {
        if (this.saved != null) {
            throw new IllegalStateException("Cannot remove when next element has been pushed back");
        }
        this.iterator.remove();
    }
}

