drop table if exists e7_nero_csv;
create table e7_nero_csv 
 ( E7_ID text COLLATE pg_catalog."default",
E7_ID_parent text COLLATE pg_catalog."default",
Bezeichnung text COLLATE pg_catalog."default",
E7_label_en text COLLATE pg_catalog."default",
E7_p3 text COLLATE pg_catalog."default",
E7_subclass text COLLATE pg_catalog."default",
E55_E7 text COLLATE pg_catalog."default",
von text COLLATE pg_catalog."default",
bis text COLLATE pg_catalog."default",
E52_Timespan text COLLATE pg_catalog."default",
E52_E7_property text COLLATE pg_catalog."default",
Beziehung_zu_E7_ID text COLLATE pg_catalog."default",
Bezihungsart_E7 text COLLATE pg_catalog."default",
Personengruppe text COLLATE pg_catalog."default",
Beziehung_zu_Person text COLLATE pg_catalog."default",
Personen text COLLATE pg_catalog."default",
Rolle text COLLATE pg_catalog."default",
E9_from text COLLATE pg_catalog."default",
E9_to text COLLATE pg_catalog."default",
Ort text COLLATE pg_catalog."default",
Beziehung_zu_E53 text COLLATE pg_catalog."default",
E41_E7 text COLLATE pg_catalog."default",
E41_E7_property text COLLATE pg_catalog."default",
I4_Prov text COLLATE pg_catalog."default",
Forschungshandlung text COLLATE pg_catalog."default",
Objekte text COLLATE pg_catalog."default",
E7_E19_property text COLLATE pg_catalog."default",
Dokumente text COLLATE pg_catalog."default",
E7_E31_property text COLLATE pg_catalog."default",
Ausstellungsobjekt text COLLATE pg_catalog."default",
Poster text COLLATE pg_catalog."default",
Link_WikiData text COLLATE pg_catalog."default",
Link_sonstige text COLLATE pg_catalog."default");

 
 
--COPY e7_csv FROM '/tmp/reise_nach_venezuela_moves.tsv' 
COPY e7_nero_csv FROM 'c:\humbolt\e7_nero.csv' 
WITH CSV DELIMITER E'\t' QUOTE E'\b' NULL AS '' HEADER;

DELETE FROM public.e7_csv
	WHERE e7_id IS NULL;
UPDATE public.e7_csv
	SET bis='2021'	WHERE bis='heute';

drop table if exists e21_csv;
create table e21_csv 
 (e21_id text COLLATE pg_catalog."default",
Vorname text COLLATE pg_catalog."default",
Nachname text COLLATE pg_catalog."default",
Personengruppe text COLLATE pg_catalog."default",
Personengruppe_Typ text COLLATE pg_catalog."default",
Geburt text COLLATE pg_catalog."default",
Tod text COLLATE pg_catalog."default",
Geburtsort text COLLATE pg_catalog."default",
Rolle text COLLATE pg_catalog."default",
Objekt text COLLATE pg_catalog."default",
Dokumente text COLLATE pg_catalog."default",
Ausstellungsobjekt text COLLATE pg_catalog."default",
Poster text COLLATE pg_catalog."default",
Link_WikiData text COLLATE pg_catalog."default",
Link_sonstiges text COLLATE pg_catalog."default");
 
COPY e21_csv FROM '/tmp/Personen.csv' 
WITH CSV DELIMITER E'\t' QUOTE E'\b' NULL AS '' HEADER;

DELETE FROM public.e21_csv
	WHERE e21_id IS NULL;


drop table if exists e53_csv;
create table e53_csv 
 (Name text COLLATE pg_catalog."default",
lat text COLLATE pg_catalog."default",
long text COLLATE pg_catalog."default",
Link text COLLATE pg_catalog."default");
 
COPY e53_csv FROM '/tmp/Orte_new.csv' 
WITH CSV DELIMITER E'\t' QUOTE E'\b' NULL AS '' HEADER;

DELETE FROM public.e53_csv
	WHERE Name IS NULL;
	
ALTER TABLE public.e53_csv ADD COLUMN geom geometry; 
UPDATE public.e53_csv
    SET geom = ST_SetSRID(ST_MakePoint("long"::float, "lat"::float), 4326);	




drop table if exists e7_nero_uri;
create table e7_nero_uri as
with myvars as (
  select
    'https://www.forth.ics.gr/' as base_uri,
    'Nero' as e15_project,
	'uibk_crm' as e15_institution,
	'http://www.cidoc-crm.org/cidoc-crm/' as crm_base_uri,
	'http://www.cidoc-crm.org/cidoc-crm/CRMsci/' as crm_sci_uri,
	'http://www.ics.forth.gr/isl/CRMinf/' as crm_inf_uri -- ' as crm_sci_uri||'I4_Proposition_Set'
)
SELECT 
e7_label_en,e55_e7,e7_nero_csv.e7_subclass,
base_uri||e15_project||'/'||SPLIT_PART(e7_nero_csv.e7_subclass,'_',1)||'/'||e7_nero_csv.e7_id as e7_uri,
case when e7_label_en IS NOT NULL then
e7_label_en
when e7_label_en IS NULL and e55_e7 IS NOT NULL and e7_nero_csv.e7_subclass = 'E67_Birth' and beziehung_zu_person='P98_brought_into_life' then
e55_e7 ||' of '||e21_split
when e7_label_en IS NULL and e55_e7 IS NOT NULL and e7_nero_csv.e7_subclass = 'E9_Move' then
e55_e7 ||' of '||e21_split||' from ' ||e9_from||' to ' ||e9_to
when e7_label_en IS NULL and e55_e7 IS NOT NULL and e7_nero_csv.e7_subclass = 'E65_Creation' then
e55_e7 ||' of '||dokumente||' by ' ||e21_split
when e55_e7 IS NOT NULL then
e55_e7 ||COALESCE(' of '||e21_split,'')||COALESCE(' at ' ||e53_split,'')
else
bezeichnung ||'(id '||e7_nero_csv.e7_id||')' 
end as e7_label,

von, bis,
--case when COALESCE(bis::int,0)-COALESCE(von::int,3000) >0
--then 
--bis::int-von::int
--else 
--NULL
--end as duration,

case when e7_nero_csv.e7_subclass like 'E%'
then 
crm_base_uri||e7_nero_csv.e7_subclass
when e7_nero_csv.e7_subclass like 'S%'
then 
crm_sci_uri||e7_nero_csv.e7_subclass
else 
crm_base_uri||'E7_Activity'
end  as e7_subclass_uri,
base_uri||e15_project||'/'||SPLIT_PART(e7_nero_csv.e7_subclass,'_',1)||'/'||e7_id_parent_split as e7_parent_uri,
base_uri||e15_project||'/'||SPLIT_PART(cont.e7_subclass,'_',1)||'/'||beziehung_zu_e7_id as e7_beziehung_uri,
base_uri||e15_project||'/E55/'||SPLIT_PART(e7_nero_csv.e7_subclass,'_',1)||'/'||MD5(e55_e7) as e55_e7_uri,
e55_e7 as e55_e7_pref_label,

crm_base_uri||bezihungsart_e7 as e7_e7_property_uri,
crm_base_uri||beziehung_zu_person as e7_e21_property_uri,
base_uri||e15_project||'/E74/'||MD5(e74_split) as e74_uri,
e74_split as e74_label,
base_uri||e15_project||'/E21/'||MD5(e21_split) as e21_uri,
e21_split as e21_label,
base_uri||e15_project||'/E52/'||MD5(e52_timespan) as e52_uri,
e52_timespan as e52_label,
crm_base_uri||e52_e7_property as e52_e7_property_uri,
base_uri||e15_project||'/E53/'||MD5(e9_from) as e53_from_uri,
e9_from as e9_from_label,
base_uri||e15_project||'/E53/'||MD5(e9_to) as e53_to_uri,
e9_to as e9_to_label,
base_uri||e15_project||'/E53/'||MD5(e53_split) as e53_uri,
crm_base_uri||Beziehung_zu_E53 as e7_e53_property_uri, 
rolle,
e53_split as e53_label,
base_uri||e15_project||'/E19/'||MD5(e19_split) as e19_uri,
'Object '||e19_split as e19_label,
crm_base_uri||E7_E19_property as e7_e19_property_uri,

base_uri||e15_project||'/E41/'||MD5(E41_E7) as e41_uri,
E41_E7 as e41_e7_label,
crm_base_uri||E41_E7_property as e41_e7_property_uri,

base_uri||e15_project||'/I4/'||I4_Prov as I4_uri,
'Propositions of '||I4_Prov as I4_Prov_label,
base_uri||e15_project||'/I2/'||I4_Prov as I2_uri,
'Belief of '||I4_Prov as I2_Prov_label,
base_uri||e15_project||'/I7/'||I4_Prov as I7_uri,
'Belief Adoption of '||I4_Prov as I7_Prov_label,
base_uri||e15_project||'/E73/'||I4_Prov as e73_uri,
'Source of '||I4_Prov as e73_Prov_label,

link_wikidata, link_sonstige, 
forschungshandlung, objekte, 
base_uri||e15_project||'/E73_document/'||MD5(dokumente) as e73_document_uri,
crm_base_uri||E7_E31_property as e7_e31_property_uri,
dokumente
FROM public.e7_nero_csv 	LEFT JOIN myvars on true
left join lateral regexp_split_to_table(personengruppe, '\|') e74_split on true
left join lateral regexp_split_to_table(personen, '\|') e21_split on true
left join lateral regexp_split_to_table(ort, '\|') e53_split on true
left join lateral regexp_split_to_table(Objekte, '\|') e19_split on true
left join lateral regexp_split_to_table(rolle, '\|') rolle_split on true
left join lateral regexp_split_to_table(e7_id_parent, '\|') e7_id_parent_split on true
left join (select e7_id,e7_subclass from e7_nero_csv) as cont on cont.e7_id=beziehung_zu_e7_id
;
--where e7_id::int =10--42-- and e7_id::int < 29
Copy e7_uri TO '/tmp/e7_humbolt.txt' 	DELIMITER E'\t' CSV HEADER ENCODING 'UTF8' ;