<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">

<xsl:template match="/">
<html>
	<head>
		<title>CRM MAPPING by Hector Gaspar Humet</title>
		<style>
			ul {list-style-type: none}
			
		</style>
	</head>
	<body>
		<xsl:apply-templates/>
	</body>
</html>
</xsl:template>

<xsl:template match="mapping">
	<xsl:apply-templates/>
</xsl:template>

<xsl:template match="map">
	<xsl:apply-templates/>
	<hr/>
</xsl:template>

<xsl:template match="domain_map">
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="link_map">
	<table border="1" cellpadding="5" width="85%">
       	 <tr align="center">
			<th style="width:10%"></th>
		     <th style="width:45%">Source</th>
       	     <th style="width:45%">CRM</th>
	        </tr>
	
		<tr align="center">
       		<td><b>Domain</b></td>
			<td><xsl:value-of select="../domain_map/src_domain_entity/node()"/></td>
			<td>
				<ul>
					<li><xsl:value-of select="../domain_map/eq_crm_domain_entity/node()"/></li>
					<xsl:apply-templates select="crm_domain_constraint"/>
				</ul>
			</td>
		</tr>
		<tr align="center">
       		<td><b>Link</b></td>
			<xsl:apply-templates select="src_path"/>
			<xsl:apply-templates select="target_path"/>
		</tr>

		<tr align="center">
			<td><b>Range</b></td>
			<xsl:apply-templates select="src_range_map"/>
		</tr>

		<xsl:apply-templates select="src_range_condition"/>

	</table>
	<xsl:apply-templates select="comment"/>
	<br/>
</xsl:template>

<xsl:template match="src_path">
	<td><xsl:value-of select="node()"/></td>
</xsl:template>

<xsl:template match="target_path">
	<td align="center">
		<ul>
			<xsl:apply-templates />
		</ul>
	</td>
</xsl:template>

<xsl:template match="crm_domain_constraint">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="crm_link">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="crm_link_constraint">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="crm_interm_entity">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="crm_interm_constraint">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="src_range_map">
	<xsl:apply-templates />
</xsl:template>

<xsl:template match="src_range_condition">
	<tr align="center">
		<td><b>Conditions</b></td>
		<td aloign="left">
			<ul>
				<xsl:apply-templates select="domain_map/src_domain_condition"/>
				<xsl:apply-templates select="link_map/src_domain_condition"/>
				<li><xsl:value-of select="node()"/></li>
			</ul>
		</td>
		<td></td>
	</tr>
</xsl:template>

<xsl:template match="domain_map/src_domain_condition">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="link_map/src_domain_condition">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="src_range_entity">
	<td><xsl:value-of select="node()"/></td>
</xsl:template>

<xsl:template match="eq_crm_range_entity">
	<td>
		<ul>
			<li><xsl:value-of select="node()"/></li>
			<xsl:apply-templates select="crm_range_constraint"/>		
		</ul>
	</td>
</xsl:template>

<xsl:template match="crm_range_constraint">
	<li><xsl:value-of select="node()"/></li>
</xsl:template>

<xsl:template match="eq_crm_domain_entity">
	<h1>
		to
		<xsl:value-of select="node()"/>
	</h1>
	<xsl:value-of select="../comment/node()"/>
</xsl:template>

<xsl:template match="src_domain_entity">
	<br/>
	<h1>
		Mapping 
		<xsl:value-of select="node()"/>
	</h1>
</xsl:template>

<xsl:template match="comment">
	<xsl:value-of select="node()"/>
</xsl:template>

</xsl:stylesheet>
